/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/*
=====================================================================

  BasicTreeNode.java

  Created by Claude Duguay
  Copyright (c) 2000

=====================================================================
*/

import javax.swing.*;


public class BasicTreeNode {
    protected String text;
    protected Icon icon, open;

    public BasicTreeNode(String text, Icon icon) {
        this(text, icon, icon);
    }

    public BasicTreeNode(String text, Icon icon, Icon open) {
        this.text = text;
        this.icon = icon;
        this.open = open;
    }

    public static BasicTreeNode createComputer(String text) {
        return new BasicTreeNode(text,
                UIManager.getIcon("FileView.computerIcon"));
    }

    public static BasicTreeNode createDrive(String text) {
        return new BasicTreeNode(text,
                UIManager.getIcon("FileView.hardDriveIcon"));
    }

    public static BasicTreeNode createFile(String text) {
        return new BasicTreeNode(text,
                UIManager.getIcon("FileView.fileIcon"));
    }

    public static BasicTreeNode createDesk(String text) {
        return new BasicTreeNode(text,
                UIManager.getIcon("DesktopIcon.icon"));
    }

    public static BasicTreeNode createFolder(String text) {
        return new BasicTreeNode(text,
                UIManager.getIcon("Tree.closedIcon"),
                UIManager.getIcon("Tree.openIcon"));
    }

    public String getText() {
        return text;
    }

    public Icon getIcon() {
        return icon;
    }

    public Icon getOpen() {
        return open;
    }
}

