/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;


/*
=====================================================================

  CheckTreeNode.java

  Created by Claude Duguay
  Copyright (c) 2000

=====================================================================
*/

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.Enumeration;


public class CheckTreeNode
        extends DefaultMutableTreeNode {
    protected boolean selected, propagate;

    public CheckTreeNode(Object data) {
        this(data, false, false);  // Changed default to not propagate. mg 4/8/02
    }

    public CheckTreeNode(Object data, boolean selected) {
        this(data, selected, true);
    }

    public CheckTreeNode(Object data, boolean selected, boolean propagate) {
        super(data);
        this.selected = selected;
        this.propagate = propagate;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (propagate)
            propagateSelected(selected);
    }

    public void propagateSelected(boolean selected) {
        Enumeration enumerator = children();
        while (enumerator.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode) enumerator.nextElement();
            node.setSelected(selected);
        }
    }

    public void setUserObject(Object obj) {
        if (obj == this) return;
        super.setUserObject(obj);
    }

}

