/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:56:49 PM
 * To change this template use Options | File Templates.
 */

public class HammerEditorPopupMenu extends JPopupMenu {
    EditorUndoAction theUndoAction = null;
    EditorRedoAction theRedoAction = null;
    EditorCutAction theCutAction = null;
    EditorCopyAction theCopyAction = null;
    EditorPasteAction thePasteAction = null;
    Object theEditor = null;
    EditorSelectAllAction theSelectAllAction = null;
//    EditorDeleteAction theDeleteAction = null;
    public HammerEditorPopupMenu(Object objEditor) {
        super();
        theEditor = objEditor;
        theUndoAction = new EditorUndoAction("Undo", null);
        theRedoAction = new EditorRedoAction("Redo", null);
        theCutAction = new EditorCutAction("Cut", null);
        theCopyAction = new EditorCopyAction("Copy", null);
        thePasteAction = new EditorPasteAction("Paste", null);
        theSelectAllAction = new EditorSelectAllAction("Select All", null);

        add(theUndoAction);
        add(theRedoAction);
        addSeparator();
        add(theCutAction);
        add(theCopyAction);
        add(thePasteAction);
        addSeparator();
        add(theSelectAllAction);

    }

    public void editorAction(String theActionName, ActionEvent evt) {

        Class clsActiveEditor = theEditor.getClass();
        Class[] clsParams = new Class[1];
        clsParams[0] = (new String()).getClass();
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[1];
            objParams[0] = theActionName;
            Object obj = m.invoke(theEditor, objParams);
            if ((obj != null) && (obj instanceof Action)) {
                Action action = (Action) obj;
                action.actionPerformed(evt);
            }
        } catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        } catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        } catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class EditorCutAction extends AbstractAction {

        public EditorCutAction(String label, Icon icon) {
            super(label, icon);
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("cut-to-clipboard", evt);
        }
    }

    class EditorSelectAllAction extends AbstractAction {

        public EditorSelectAllAction(String label, Icon icon) {
            super(label, icon);
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("select-all", evt);
        }
    }

    class EditorCopyAction extends AbstractAction {

        public EditorCopyAction(String label, Icon icon) {
            super(label, icon);
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("copy-to-clipboard", evt);
        }
    }

    class EditorPasteAction extends AbstractAction {

        public EditorPasteAction(String label, Icon icon) {
            super(label, icon);
        }

        public void actionPerformed(ActionEvent evt) {
            editorAction("paste-from-clipboard", evt);
        }
    }

    class EditorUndoAction extends AbstractAction {

        public EditorUndoAction(String label, Icon icon) {
            super(label, icon);
        }

        public void actionPerformed(ActionEvent evt) {
            Class clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[0];
            try {
                Method m = clsActiveEditor.getMethod("undo", clsParams);
                Object[] objParams = new Object[0];
                Object obj = m.invoke(theEditor, objParams);
            } catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            } catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            } catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class EditorRedoAction extends AbstractAction {

        public EditorRedoAction(String label, Icon icon) {
            super(label, icon);
        }

        public void actionPerformed(ActionEvent evt) {
            Class clsActiveEditor = theEditor.getClass();
            Class[] clsParams = new Class[0];
            try {
                Method m = clsActiveEditor.getMethod("redo", clsParams);
                Object[] objParams = new Object[0];
                Object obj = m.invoke(theEditor, objParams);
            } catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            } catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            } catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

}
