/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.util.ArrayList;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class MetaConstructorArgument {
    String sType = null;
    ArrayList aValue = new ArrayList(3);
    String sName = null;
    String sClass = null;
    MetaConstructorArgument theNextParameter = null;

    public MetaConstructorArgument() {
    }

    public MetaConstructorArgument(String sTheValue) {
        aValue.add(sTheValue);
    }

    /**
     * Create() - Generates an object that represents the parameter specified
     *            in the metadata.  An object is returned.
     */
    public Object Create() {
        // Here begins special code for string array parameters.
        if (sClass.equals("String[]")) {
            // aValue contains a list of strings.
            int iStringCount = aValue.size();
            String[] sStringValues = new String[iStringCount];
            for (int j = 0; j < iStringCount; j++)
                sStringValues[j] = aValue.get(j).toString();
            return sStringValues;
        } else {  // Simple stuff (not arrays of objs or strings or vectors)
            if (sClass.equals("String"))
                return aValue.get(0).toString();
            if (sClass.equals("Integer"))
                return new Integer(aValue.get(0).toString());
        }
        try {
            Class cThisClass = Class.forName(sClass);
            return cThisClass.newInstance();
        } catch (Exception e) {
            return null;
        }
    }

    public MetaConstructorArgument Clone() {
        MetaConstructorArgument theReturnValue = new MetaConstructorArgument();
        theReturnValue.sType = sType;
        theReturnValue.sName = sName;
        theReturnValue.sClass = sClass;
        theReturnValue.aValue = new ArrayList(aValue);
        return theReturnValue;
    }
}

