/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class MetaConstructorArgumentList {
    MetaConstructorArgument theFirstParameter = null;
    MetaConstructorArgument theLastParameter = null;
    public int iParamCount = 0;

    public MetaConstructorArgumentList() {
    }

    public MetaConstructorArgument getFirstParameter() {
        return theFirstParameter;
    }

    public MetaConstructorArgument getLastParameter() {
        return theLastParameter;
    }

    public MetaConstructorArgument getParameter(int iParam) {
        MetaConstructorArgument theReturnValue = getFirstParameter();
        int i = 0;
        while (theReturnValue != null) {
            if (iParam == i)
                break;
            theReturnValue = theReturnValue.theNextParameter;
            i++;
        }
        return theReturnValue;
    }

    public void add(MetaConstructorArgument theNewParameter) {
        if (theFirstParameter == null)
            theFirstParameter = theNewParameter;
        else
            theLastParameter.theNextParameter = theNewParameter;
        theLastParameter = theNewParameter;
    }
}

