/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

/**
 * This class is used for code generation and also to determine how a control
 * is placed in the view displayer of the design cockpit.
 */

public class MetaContainerType {

    static public final int CONTAINER_NONE = 0;
    static public final int CONTAINER_SCROLLPANE = 1;
    static public final int CONTAINER_PANEL = 2;
    static public final int CONTAINER_FRAME = 3;
    static public final int CONTAINER_TABBEDPANE = 4;
    static public final int CONTAINER_ABALET = 5;
    static public final int CONTAINER_BUTTONGROUP = 6;
    static public final int CONTAINER_TABPAGE = 7;
    static public final int CONTAINER_HSPLIT = 8;
    static public final int CONTAINER_VSPLIT = 9;
    static public final int CONTAINER_SCROLLING_PANEL = 10;
    static public final int CONTAINER_JMENUBAR = 11;
    static public final int CONTAINER_JMENU = 12;
    static public final int CONTAINER_JMENUITEM = 13;
    static public final int CONTAINER_JTOOLBAR = 14;

    int iContainerType;

    public MetaContainerType() {
    }

    public MetaContainerType(int iType) {
        iContainerType = iType;
    }

    public MetaContainerType(String sType) {
        if (sType != null)
            setContainerType(sType);
    }

    public void setContainerType(int iType) {
        iContainerType = iType;
    }

    public void setContainerType(String sType) {
        if (sType.equalsIgnoreCase("none"))
            iContainerType = CONTAINER_NONE;
        if (sType.equalsIgnoreCase("scrollpane"))
            iContainerType = CONTAINER_SCROLLPANE;
        if (sType.equalsIgnoreCase("panel"))
            iContainerType = CONTAINER_PANEL;
        if (sType.equalsIgnoreCase("frame"))
            iContainerType = CONTAINER_FRAME;
        if (sType.equalsIgnoreCase("tabbedpane"))
            iContainerType = CONTAINER_TABBEDPANE;
        if (sType.equalsIgnoreCase("abalet"))
            iContainerType = CONTAINER_ABALET;
        if (sType.equalsIgnoreCase("group"))
            iContainerType = CONTAINER_BUTTONGROUP;
        if (sType.equalsIgnoreCase("tabpage"))
            iContainerType = CONTAINER_TABPAGE;
        if (sType.equalsIgnoreCase("hsplit"))
            iContainerType = CONTAINER_HSPLIT;
        if (sType.equalsIgnoreCase("vsplit"))
            iContainerType = CONTAINER_VSPLIT;
        if (sType.equalsIgnoreCase("scrollingpanel"))
            iContainerType = CONTAINER_SCROLLING_PANEL;
        if (sType.equalsIgnoreCase("menubar"))
            iContainerType =  CONTAINER_JMENUBAR;
        if (sType.equalsIgnoreCase("menu"))
            iContainerType =  CONTAINER_JMENU;
        if (sType.equalsIgnoreCase("menuitem"))
            iContainerType =  CONTAINER_JMENUITEM;
        if (sType.equalsIgnoreCase("toolbar"))
            iContainerType =  CONTAINER_JTOOLBAR;
    }

    public int getContainerType() {
        return iContainerType;
    }

    public String getContainerTypeAsString() {
        return MetaContainerType.getContainerTypeAsString(iContainerType);
    }

    public static String getContainerTypeAsString(int iContainerType) {
        switch (iContainerType) {
            case CONTAINER_NONE:
                return "none";
            case CONTAINER_SCROLLPANE:
                return "scrollpane";
            case CONTAINER_PANEL:
                return "panel";
            case CONTAINER_FRAME:
                return "frame";
            case CONTAINER_TABBEDPANE:
                return "tabbedpane";
            case CONTAINER_ABALET:
                return "abalet";
            case CONTAINER_BUTTONGROUP:
                return "group";
            case CONTAINER_TABPAGE:
                return "tabpage";
            case CONTAINER_HSPLIT:
                return "hsplit";
            case CONTAINER_VSPLIT:
                return "vsplit";
            case CONTAINER_SCROLLING_PANEL:
                return "scrollingpanel";
            case CONTAINER_JMENUBAR:
                return "menubar";
            case CONTAINER_JMENU:
                return "menu";
            case CONTAINER_JMENUITEM:
                return "menuitem";
            case CONTAINER_JTOOLBAR:
                return "toolbar";

        }
        return "";
    }
}
