/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;




/**
 * Title:        uifactory
 * Description:  This class builds blueprint objects for each class.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class UIFactoryComponentFactory {

    /**
     * sPreConstructionCode - This is the code that executes before construction
     * of the component.  It is typically used to declare temps that appear in
     * the constructor param list.
     */

    String sPreConstructionCode = null;

    /**
     * sConstructorParamList - This is the list of parameters that will appear in
     * the source code of the constructor invocation.
     */

    String sConstructorParamList = null;

    /**
     * sPostConstructionCode - This is the stuff that comes after the constructor.
     */

    String sPostConstructionCode = null;

    /**
     * BroadcasterHead is used to determine an object from a list of the declared
     * objects.  This is only valid for object component within component
     * construction.  For class component construction, the list of members is
     * searched instead.  The BroadcasterHead is null for class component
     * construction.
     */

    UIFactoryBroadcaster BroadcasterHead = null;

    /**
     * A link to factory metadata.  This is used to reference names of final fields
     * and so forth.
     */

    MetadataProvider factoryMetadata = null;

    /**
     *   param objMetaObject - This is the object created with this class by the component constructor.
     *   This object is only constructed for object component construction.
     */

    Object objMetaObject = null;

    /**
     * Create a component constructor - do not specify default values.
     */

    public UIFactoryComponentFactory() {
    }

    /**
     * Create a component constructor.
     *
     *
     */

    public UIFactoryComponentFactory(UIFactoryBroadcaster theBroadcasterHead,
                                     MetadataProvider theFactoryMetadata) {
        BroadcasterHead = theBroadcasterHead;
        factoryMetadata = theFactoryMetadata;
    }


}
