/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common.jdbc;

/**
 * Created by IntelliJ IDEA.
 * User: Mario Castillo , Castellum Technologies c/o Abacus Research AG
 * Date: May 13, 2004
 * Time: 11:08:32 PM
 */

import com.nqadmin.swingSet.SSTextDocument;

import javax.sql.RowSet;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;

public class JSSCheckBox extends JCheckBox {


    private JTextField textField = null;

    private JSSCheckBoxListener checkBoxListener = new JSSCheckBoxListener();
    private JSSTextFieldListener textFieldListener = new JSSTextFieldListener();

    private int language = 0; //  0 = DE , 1 = ENG , 2 = FR , 3 = IT
    public String FieldName = null;
    public RowSet rs = null;
    private SSTextDocument sstxdoc = null;
    private JSSDataSource editDataSource = null;
    private int dbFieldType = -1;

    private int CHECKED = 1;
    private int UNCHECKED = 0;

    private String DE_CHECKED = "J";
    private String DE_UNCHECKED = "N";
    private String EN_CHECKED = "Y";
    private String EN_UNCHECKED = "N";
    private String FR_CHECKED = "O";
    private String FR_UNCHECKED = "N";

    private char[][] multiLangOptions = {{'J', 'N'},
                                         {'Y', 'N'},
                                         {'O', 'N'}};

    public JSSCheckBox() {
        textField = new JTextField();
        this.initCheckBox();
    }

    public JTextField getTextField() {
        return textField;
    }

    private void initCheckBox() {

        textField.getDocument().addDocumentListener(textFieldListener);

        if (textField.getText().equals(String.valueOf(CHECKED))) {
            setSelected(true);
        } else {
            setSelected(false);
        }
        addChangeListener(checkBoxListener);
    }

    private void setRowSet() {
        if (rs != null && FieldName != null) {
            sstxdoc = new SSTextDocument(this.rs, FieldName);
            textField.setDocument(sstxdoc);
            textField.getDocument().removeDocumentListener(textFieldListener);
            textField.getDocument().addDocumentListener(textFieldListener);
            try {
                int colNum = rs.findColumn(FieldName);
                ResultSetMetaData rm = rs.getMetaData();
                dbFieldType = rm.getColumnType(colNum);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setDataSource(JSSDataSource ds) {
        editDataSource = ds;
        this.rs = ds.getRowSet();
        this.setRowSet();
    }

    public void setFieldName(String sData) {
        FieldName = sData;
        this.setRowSet();
    }

    public ArrayList getFieldNames() {
        return editDataSource.getFieldNames();
    }

    private void setTextDataFromCheckBox(ChangeEvent changeEvent) {
        switch (dbFieldType) {
            case java.sql.Types.INTEGER:
                {
                    if (((JCheckBox) changeEvent.getSource()).isSelected()) {
                        textField.setText(String.valueOf(CHECKED));
                    } else {
                        textField.setText(String.valueOf(UNCHECKED));
                    }
                }
                break;
            case java.sql.Types.CHAR:
                {
                    if (((JCheckBox) changeEvent.getSource()).isSelected()) {
                        textField.setText(String.valueOf(multiLangOptions[language][0]));
                    } else {
                        textField.setText(String.valueOf(multiLangOptions[language][1]));
                    }
                }
                break;
            case java.sql.Types.BOOLEAN:
                {
                    if (((JCheckBox) changeEvent.getSource()).isSelected()) {
                        textField.setText(String.valueOf(true));
                    } else {
                        textField.setText(String.valueOf(false));
                    }
                }
                break;

        }

    }

    private void setCheckBoxFromTextData(DocumentEvent docEvent) {
        switch (dbFieldType) {
            case java.sql.Types.INTEGER:
                {
                    if (textField.getText().equals(String.valueOf(CHECKED))) {
                        setSelected(true);
                    } else {
                        setSelected(false);
                    }
                }
                break;
            case java.sql.Types.CHAR:
                {
                    char tmpChar = multiLangOptions[language][0];
                    if (textField.getText().equals(String.valueOf(tmpChar))) {
                        setSelected(true);
                    } else {
                        setSelected(false);
                    }
                }
                break;
            case java.sql.Types.BOOLEAN:
                {
                    if (textField.getText().equals("true")) {
                        setSelected(true);
                    } else {
                        setSelected(false);
                    }
                }
                break;
        }

    }

    private class JSSTextFieldListener implements DocumentListener {

        public void changedUpdate(DocumentEvent de) {
        }

        public void insertUpdate(DocumentEvent de) {
            removeChangeListener(checkBoxListener);
            setCheckBoxFromTextData(de);
            addChangeListener(checkBoxListener);
        }

        public void removeUpdate(DocumentEvent de) {
            removeChangeListener(checkBoxListener);
            setCheckBoxFromTextData(de);
            addChangeListener(checkBoxListener);
        }
    }

    private class JSSCheckBoxListener implements ChangeListener {

        public void stateChanged(ChangeEvent ce) {

            textField.getDocument().removeDocumentListener(textFieldListener);
            setTextDataFromCheckBox(ce);
            textField.getDocument().addDocumentListener(textFieldListener);
        }

    }

}
