/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @(#) AdditiveCongruence.java     1.0 04.11.2002 10:18:37 Pecar
 *
 * Copyright (c) 2002 ABACUS Research AG, All Rights Reserved
 *
 */

package ch.abacus.lib.util.math;

public class AdditiveCongruence {
  private int[] field;
  private int pos;

  private int m;

  public AdditiveCongruence(int[] initField, int m) {
    pos = 0;
    if(initField == null)
      throw new NullPointerException();
    field = initField;
    this.m = m;
  }

  public static final AdditiveCongruence createNew() {
    int[] field = new int[55];
    for(int i=0; i<field.length; i++)
      field[i] = LinearCongruence.random();
    return new AdditiveCongruence(field, 100000000);
  }

  public static final AdditiveCongruence createNew(int seed) {
    LinearCongruence lc = new LinearCongruence(seed);
    int[] field = new int[55];
    for(int i=0; i<field.length; i++)
      field[i] = lc.next();
    return new AdditiveCongruence(field, 100000000);
  }

  private static final int MULT_HELP = 10000;
  public int random(int r) {
    pos = (pos + 1) % field.length;
    field[pos] = (field[(pos + 23) % field.length] + field[(pos + 54) % field.length]) % m;
    return ((field[pos] / MULT_HELP) * r) / MULT_HELP;
  }

  private static final int BITS_PER_BYTE = 8;
  private static final int BYTES_PER_INT = 4;
  public void nextBytes(byte[] bytes) {
    int numRequested = bytes.length;
    int numGot = 0, rnd = 0;
    while(true) {
      for(int i = 0; i < BYTES_PER_INT; i++) {
        if(numGot == numRequested)
          return;
        rnd = (i==0 ? random(BITS_PER_BYTE * BYTES_PER_INT) : rnd >> BITS_PER_BYTE);
        bytes[numGot++] = (byte)rnd;
      }
    }
  }
}
