/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * IntMath.java  
 *
 * Creator:
 * 04.07.2005 16:53:32 Pecar
 *
 * Maintainer:
 * 04.07.2005 16:53:32 Pecar
 *
 * Last Modification:
 * $Id: IntMath.java,v 1.2 2005/07/04 15:21:57 pecar Exp $
 *
 * Copyright (c) 2005 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.util.math;

public class IntMath {
    /**
     * this function add integer without an overflow.
     * <p/>
     * if the sum of i1 and all args gives more than Integer.MAX_VALUE the return will be Integer.MAX_VALUE.
     * in case of an underflow it will be Integer.MIN_VALUE
     *
     * @param i1
     * @param args
     * @return
     */
    public static final int add(int i1, int... args) {
        long result = i1;
        if(args != null) {
            for(int i=0; i<args.length; i++)
                result += args[i];
        }
        return result > Integer.MAX_VALUE ? Integer.MAX_VALUE : result < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int) result;
    }

    /**
     * the mulDiv function multiplies two int values and then divides the long result by a third int value.
     *
     * @param number  the multiplicand
     * @param factor  the multiplier
     * @param divisor the number by which the result of the multiplication (<tt>number</tt> * <tt>factor</tt>) is to be divided
     * @return the result of the calculation
     */
    public static int mulDiv(int number, int factor, int divisor) {
        long l = ((long) number) * ((long) factor);
        return (int) (l / divisor);
    }
}
