#!/bin/bash

JAVA_EXECUTABLE="java";

# chmod +x ./verifyjava.sh
echo "Verify java version ..."
../bin/verifyjava.sh
if [ $? = 0 ]
then
        echo " "
else
        echo "Verify java failed"

	echo "Try to find a usable Java executable ..."
	for afile in $( find /usr -type f -name java -a -print 2>/dev/null )
	do 
		jver=`$afile -version 2>&1 | grep 'java version' 2>&1 | awk '{print $3}' | sed 's/\"//g'`;
		val=`$afile -version 2>&1 | grep -c '1.[5-9].[0-9]'`;
		val1=`$afile -version 2>&1 | grep -c '2.[0-9].[0-9]'`;
	
		if [ "$val" -gt 0 ] || [ "$val1" -gt 0 ]
		then
			JAVA_EXECUTABLE="$afile";
			adir=`dirname $afile`;
			JAVA_HOME=`dirname $adir`;
			echo "Found a usable java executable: $JAVA_EXECUTABLE";
			break;
		fi
	done
fi


# Mac: export CLASSPATH="/System/Library/Frameworks/JavaVM.framework/Versions/1.4.2/Libraries"
# Mac: export DC_JARS="/Users/abacus/Desktop/abaguibuilder-1.5/bin"

export DC_JARS="../bin"

export CLASSPATH=$JAVA_HOME/lib/tools.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/abalib.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/abadc.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/EXML.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/cf.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/cbeans.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/cutils.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/ozten.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/rowset.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/swingset-bin_0.7.0_beta.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/mysql-connector-3.0.14.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/janino.jar

export CLASSPATH=$CLASSPATH:$DC_JARS/customcomponents/abaguicustom.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/customcomponents/dev.customcomponents.AbacusCustom.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/customcomponents/jcommon-1.0.0-pre2.jar
export CLASSPATH=$CLASSPATH:$DC_JARS/customcomponents/jfreechart-1.0.0-pre2.jar

export CLASSPATH=$CLASSPATH:.

echo " "
echo JAVA_HOME is now set to $JAVA_HOME
echo Java executable is $JAVA_EXECUTABLE
$JAVA_EXECUTABLE -Xms128m -Xmx384m exec $1
