/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaMethod;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:37:48 PM
 * To change this template use Options | File Templates.
 */

public class LizardMethodComboBoxModel extends AbstractListModel implements ComboBoxModel {
    Object objSelection = null;
    MetaClass theMetaClass = null;
    MetaMethod[] theMethods = null;

    public LizardMethodComboBoxModel() {
        super();
    }

    public void setSelectedItem(Object theSelection) {
        objSelection = theSelection;
    }

    public Object getSelectedItem() {
        return objSelection;
    }


    public Object getElementAt(int iIndex) {
        if ((theMethods != null) && (theMethods[iIndex] != null))
            return theMethods[iIndex].getMethodName();
        else
            return null;
    }

    public int getSize() {
        int iSize = 0;
        if (theMetaClass != null)
            iSize = theMetaClass.getMetadata().iNumberOfMethods;
        return iSize;
    }

    protected void Load(MetaClass someMetaClass) {
        int i = 0;
        theMetaClass = someMetaClass;
        if (theMetaClass.getMetadata().iNumberOfMethods != 0) {
            theMethods = new MetaMethod[theMetaClass.getMetadata().iNumberOfMethods];
            MetaMethod theMethod = someMetaClass.getMetadata().theFirstMethod;
            while (theMethod != null) {
                theMethods[i++] = theMethod;
                theMethod = theMethod.getNextMethod();
            }
        }
    }
}
