/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;


import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;

import java.awt.*;
import java.awt.event.*;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


/**
 * Title:        uifactory
 * Description:  This is a program design tool that creates Abacus java applications using the UI Factory.  The output of this tool is an xml document that is processed by the UI factory to create the java programs.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class LizardValueChoiceComboBox extends LizardComboBox {

    LizardValueChoiceComboBoxModel theModel = null;
    MetaPropertyDescriptor theProperty = null;
    Component theDefaultNextFocus = null;

    public LizardValueChoiceComboBox(LizardValueChoiceComboBoxModel objModel, Object objReceiver) {
        super(objModel, objReceiver);
        theModel = objModel;
        theModel.theComboBox = this;
        theReceiver = objReceiver;
        setEditable(true);
        setMaximumRowCount(10);
//      addActionListener(new LizardValueChoiceComboBoxListener());
    }

    public void Load(MetaPropertyDescriptor someProperty) {
        theProperty = someProperty;
        theModel.Load(someProperty, null);
        updateUI();
    }

    public void resetContents() {
        theProperty = null;
        theModel.theProperty = null;
        updateUI();
    }

    public void Reload(MetaPropertyDescriptor someProperty) {
        theProperty = someProperty;
        theModel.Load(someProperty, null);
        updateUI();
    }

    public void selectItem() {
        String sSelectedItem = (String) getSelectedItem();
        selectItem(sSelectedItem);
    }

    public void appendItem(String sText) {
        theProperty.addValueChoice(sText);
        Load(theProperty);
    }

    public void selectItem(String sSelectedItem) {
        if (sSelectedItem == null)
            return;
        if (sSelectedItem.trim().length() == 0)
            return;
        configureEditor(getEditor(), sSelectedItem);
        // Find out if it already exists.
        for (int i = 0; i < getItemCount(); i++) {
            if (getItemAt(i).equals(sSelectedItem)) {
                setSelectedItem(sSelectedItem);
                return;
            }
        }
        // If not, add a new MemberData.
        appendItem(sSelectedItem);
    }

}

class LizardValueChoiceComboBoxListener implements ActionListener {

    public void actionPerformed(ActionEvent evt) {

        LizardValueChoiceComboBox theCombo = (LizardValueChoiceComboBox) evt.getSource();
        theCombo.selectItem();
    }

}
