/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: May 28, 2004
 * Time: 12:47:31 PM
 */
package ch.abacus.designcockpit.external;

import ch.abacus.lib.ui.validation.AbaKeyboardFocusManager;

import javax.swing.*;

public abstract class IDEFocusRequester {
    public static void requestFocus(JComponent nodeFocusRequested) {
        AbaKeyboardFocusManager.requestFocus(nodeFocusRequested);
    }

    public static boolean requestFocus(JComponent nodeFocusRequested, boolean bTemporary) {
        nodeFocusRequested.requestFocusInWindow();
        return nodeFocusRequested.requestFocus(bTemporary);
    }

    public static boolean requestFocusInWindow(JComponent nodeFocusRequested) {
        return nodeFocusRequested.requestFocusInWindow();
    }
}