/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.BorderFactory;
import ch.abacus.lib.ui.customizer.CustomizerAvailableClass;

import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart Booth (Live Clue, inc)
 * Date: May 29, 2005
 * Time: 11:44:57 AM
 */
public class CustomizerAlternativeClassesDialog extends JDialog {
    private final CustomizerAvailableClass[] m_alternativeClasses;
    private String m_selectedClassName;
    private SuperDesignCockpit m_owner;

    public CustomizerAlternativeClassesDialog(SuperDesignCockpit owner, String title, CustomizerAvailableClass[] alternativeClasses) {
        super(owner, title, true);
        m_owner = owner;
        m_alternativeClasses = alternativeClasses;

        populateDialog();
        pack();
        setLocationRelativeTo(null);
    }


    private void populateDialog() {
        Container contentPane = getContentPane();

        contentPane.setLayout(new VerticalFlowLayout());

        JALabel text = new JALabel(m_owner.theLanguageManager.getMessage("SelectAlternativeClassDialog.description", "Which component do you want to use for this Field?"));
        text.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        contentPane.add(text);

        final JARadioGroup radioGroup = new JARadioGroup();
        radioGroup.setBorder(BorderFactory.createEmptyBorder(10, 50, 10, 50));
        radioGroup.setLayout(new GridLayout(m_alternativeClasses.length, 1, 10, 10));
        for (int iClass = 0; iClass < m_alternativeClasses.length; iClass++) {
            radioGroup.addRadioButton(m_alternativeClasses[iClass].getDisplayName());
        }
        radioGroup.setSelectedIndex(0);

        contentPane.add(radioGroup);

        JAButton btnOK = new JAButton(m_owner.theLanguageManager.getMessage("Dialogs.OK", "OK"));
        JAPanel panel = new JAPanel();
        ((FlowLayout)panel.getLayout()).setAlignment(FlowLayout.RIGHT);
        panel.add(btnOK);
        contentPane.add(panel);

        btnOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                m_selectedClassName = m_alternativeClasses[radioGroup.getSelectedIndex()].getMetadataClassName();
                CustomizerAlternativeClassesDialog.this.hide();
            }
        });

    }
//    private void populateDialog() {
//        Container contentPane = getContentPane();
//
//        contentPane.setLayout(new BorderLayout(10,0));
//        final JARadioGroup radioGroup = new JARadioGroup();
//        radioGroup.setBorder(BorderFactory.createEmptyBorder(10, 50, 10, 50));
//        radioGroup.setLayout(new GridLayout(m_alternativeClasses.length, 1, 10, 10));
//        for (int iClass = 0; iClass < m_alternativeClasses.length; iClass++) {
//            radioGroup.addRadioButton(m_alternativeClasses[iClass].getDisplayName());
//        }
//        radioGroup.setSelectedIndex(0);
//
//        contentPane.add(radioGroup, BorderLayout.NORTH);
//
//        JAButton btnOK = new JAButton(m_owner.theLanguageManager.getMessage("Dialogs.OK", "OK"));
//        JAPanel panel = new JAPanel();
//        ((FlowLayout)panel.getLayout()).setAlignment(FlowLayout.RIGHT);
//        panel.add(btnOK);
//        contentPane.add(panel, BorderLayout.SOUTH);
//
//        btnOK.addActionListener(new ActionListener() {
//            public void actionPerformed(ActionEvent e) {
//                m_selectedClassName = m_alternativeClasses[radioGroup.getSelectedIndex()].getMetadataClassName();
//                CustomizerAlternativeClassesDialog.this.hide();
//            }
//        });
//
//    }

    public String getSelectedClassName() {
        return m_selectedClassName;
    }
}
