/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaContainerType;

import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 6, 2003
 * Time: 10:00:49 AM
 * To change this template use Options | File Templates.
 */

public class IDEComponentPaletteSelectionListener implements TreeSelectionListener {
    SuperDesignCockpit theDesignCockpit;
    IDEComponentPaletteNode theLastSelectedNodeForDragging = null;

    public IDEComponentPaletteSelectionListener(IDEComponentPalette theTree) {
        theDesignCockpit = theTree.theCockpit;
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath thePath = evt.getPath();
        JComponent theComponent = (JComponent) evt.getSource();
        IDEComponentPalette theTree = (IDEComponentPalette) theComponent;
        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode) thePath.getLastPathComponent();
        theTree.clearDragErrorCondition();  // Clear error flag.

        if ((theSelectedNode != null) && (theSelectedNode.isCustomizerDataElement())) {
            if (theSelectedNode.isCustomizerDataElementGroup()) {
                theTree.setSelectedNode(theSelectedNode);
                theDesignCockpit.setMouseSelectState(false);
                return;
            }
        }

        // You can get valueChanged while you are dragging.  This avoids the reentrancy.
        if (theSelectedNode.equals(theLastSelectedNodeForDragging)) {
            if ((theSelectedNode != null) && (theSelectedNode.getMetaClass() != null)) {
                if (theSelectedNode.getChildCount() == 0) {
                    theTree.setSelectedNode(theSelectedNode);
                    theDesignCockpit.setMouseSelectState(false);
                }
                return;
            }
        } else
            theLastSelectedNodeForDragging = theSelectedNode;

        if ((theSelectedNode != null) && (theSelectedNode.getMetaClass() != null)) {
            // Disallow selection of a non frame or non abalet when there is nothing in the project.
            int iContainerType = theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType();
            if (theDesignCockpit.getDesignProject().getFirstObject() == null) {
                if ((iContainerType != MetaContainerType.CONTAINER_ABALET) && (iContainerType != MetaContainerType.CONTAINER_FRAME)) {
                    theTree.setDragErrorCondition(IDEComponentPalette.INVALID_TOP_LEVEL_SELECTION);  // error.
                }
            } else {  // abalet must be top object.
                if (iContainerType == MetaContainerType.CONTAINER_ABALET)
                    theTree.setDragErrorCondition(IDEComponentPalette.INVALID_ABALET_SELECTION);  // error.
                else if (iContainerType == MetaContainerType.CONTAINER_TABPAGE)
                    theTree.setDragErrorCondition(IDEComponentPalette.USE_TABBEDPANE_MENU_OPTION);  // error.
            }
            int iError = theTree.getDragErrorCondition();
            theTree.setSelectedNode(null);
            int iChildCount = theSelectedNode.getChildCount();
            if (iError == IDEComponentPalette.NO_ERROR) {
                if (iChildCount > 0) {
                    theDesignCockpit.setMouseSelectState(true);
                    theTree.setDragErrorCondition(IDEComponentPalette.INVALID_SELECTION);
                } else {
                    theDesignCockpit.setMouseSelectState(false);
                    theTree.setSelectedNode(theSelectedNode);
                }
            }
        }
//        else {
//            theDesignCockpit.theLogFile.doLogEntry("IDEComponentPalettePane", "No selected node");
//        }
    }
}
