/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.lang.reflect.Method;
import java.lang.reflect.Field;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Mario Castillo
 * @version 1.3 Open Source Version
 */

class IDEKeyDescriptor {
    MetaObject theMetaObject;
    String sTitle;
    String sName;

    public IDEKeyDescriptor(MetaObject theMetaObject, String sTitle, String sName) {
        this.theMetaObject = theMetaObject;
        this.sTitle = sTitle;
        this.sName = sName;
    }
}


class IDEKeyControlEditorTableModel extends AbstractTableModel {

    MetaObject theMetaObject = null;
    ArrayList theKeyPages = null;
    IDEKeyControlEditorTable theTable = null;
    int[] tabKeyIndex = null;
    ArrayList KeyEventProps = null;

    public IDEKeyControlEditorTableModel()
    {
        KeyEventProps = new ArrayList();
       // Field[] keys = getEventKeys();
    }

    public void setArrayIndex(int row, int value) {
        tabKeyIndex[row] = value;
        // Tell the table that it has changed.
        TableModelEvent event = new TableModelEvent(this, row, row);
        theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (theKeyPages == null)
            return 0;
        else
            return theKeyPages.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        IDEKeyDescriptor theDescriptor = (IDEKeyDescriptor) theKeyPages.get(row);
        if (theDescriptor != null) {
            if (column == 0) {  // object name
                theDescriptor.sName = (String) theNewValue;
            } else {  //object title
                theDescriptor.sTitle = (String) theNewValue;
            }
        }
    }

    public Object getValueAt(int row, int column) {
        IDEKeyDescriptor theDescriptor = (IDEKeyDescriptor) theKeyPages.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                return theDescriptor.sName;
            } else {
                return theDescriptor.sTitle;
            }
        }
        return "";
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        return theClassName.getClass();
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0)
            return false;
        else
            return true;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0)
            return "Menu Item";
        else
            return "Keys";
    }

    protected void Load(IDEKeyControlEditorTable objTable) {
        theKeyPages = new ArrayList();
        if (theMetaObject != null) {
            MetaObject theMenu = theMetaObject.theFirstChild;
            int iPage = 0;
            while (theMenu != null) {
                if(!(theMenu.theVisualObject instanceof JSeparator))
                {
                    MetaPropertyValueEx pvValue = theMenu.getPropertyValue("Accelerator", 0);
                    String theTitle = "";
                    if (pvValue != null)
                        theTitle = new String(pvValue.getStringValue());
                    IDEKeyDescriptor theDescriptor = new IDEKeyDescriptor(theMenu, theTitle, theMenu.getName());
                    theKeyPages.add(theDescriptor);
                }
                theMenu = theMenu.theNextObject;
            }
        }
    }

    protected void clear() {
        theKeyPages = new ArrayList();
    }
}

class IDEKeyControlEditorTableMouseListener implements MouseListener {
    IDEKeyControlEditorTable theTable;

    public IDEKeyControlEditorTableMouseListener(IDEKeyControlEditorTable theTable) {
        this.theTable = theTable;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() != MouseEvent.BUTTON1) {
            Point pt = evt.getPoint();
            int iRow = theTable.rowAtPoint(pt);
            new AbaNLSSelector(theTable.theModel.theMetaObject,  "Accelerator", iRow, theTable.theDesignCockpit, theTable);
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

}


class IDEKeyControlEditorTable extends JATable {

    public IDEKeyControlEditorTableModel theModel = null;
    public SuperDesignCockpit theDesignCockpit;
    char[ ] editShortcuts = { ' ','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P',
                              'Q','R','S','T','V','U','W','X','Y','Z' };
    public IDEKeyControlEditorTable(IDEKeyControlEditorTableModel theTableModel, SuperDesignCockpit theDesignCockpit) {
        super(theTableModel);
        theModel = theTableModel;
        this.theDesignCockpit = theDesignCockpit;
        this.addMouseListener(new IDEKeyControlEditorTableMouseListener(this));
        TableColumn keyChar = this.getColumnModel().getColumn(1);
        JComboBox comboBox = new JComboBox();
         for (int i=0; i < editShortcuts.length; i++)
         {
            comboBox.addItem( String.valueOf(editShortcuts[i]) );
         }
         keyChar.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
    }

    public void Load() {
        theModel.Load(this);
        repaint();
    }

    public void resetContents() {
        theModel.clear();
        repaint();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = getDefaultRenderer(theModel.getColumnClass(column));
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {

        TableColumn tableColumn = getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null)
            editor = getDefaultEditor(theModel.getColumnClass(column));
        return editor;
    }

    public void newValueSelected(String sNewValue, String sPropertyName, Integer theRow) {
        theModel.setValueAt(sNewValue, theRow.intValue(), 1);
    }

}


public class IDEKeyControlEditor extends JADialog {
    MetaObject theObject;
    IDEKeyControlEditorTableModel theModel = new IDEKeyControlEditorTableModel();
    IDEKeyControlEditorTable theKeyControlTable;
    JAScrollPane theKeyControlScrollPane;
//    UpButtonAction theUpAction;
//    DownButtonAction theDownAction;
    OKButtonAction theOKAction;
    CancelButtonAction theCancelAction;
    SuperDesignCockpit theDesignCockpit;
    JAButton theOKButton;
    JAButton theCancelButton;
    AnchoringLayoutManager layoutManager = new AnchoringLayoutManager();

    public IDEKeyControlEditor() {
        super((JAFrame) null, "Key Control Editor", true);
    }

    public IDEKeyControlEditor(MetaObject theObject, String sPropertyName, SuperDesignCockpit theDesignCockpit)
    {
        super(theDesignCockpit, "Key Control Editor", true, false);
        this.theDesignCockpit = theDesignCockpit;
        this.theObject = theObject;
        this.theModel.theMetaObject = theObject;
        theKeyControlTable = new IDEKeyControlEditorTable(theModel, theDesignCockpit);
        theKeyControlScrollPane = new JAScrollPane(theKeyControlTable);
        this.theKeyControlTable.Load();
        theOKAction = new OKButtonAction(this, theObject);
        theCancelAction = new CancelButtonAction(this, theObject);
        theOKButton = new JAButton(theOKAction);
        theCancelButton = new JAButton(theCancelAction);

        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());

        JAPanel pnlTable = new JAPanel();
        pnlTable.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        pnlTable.setLayout(new BorderLayout());
        pnlTable.add(theKeyControlScrollPane, BorderLayout.CENTER);
        pane.add(pnlTable, BorderLayout.CENTER);

        JAPanel pnlButtons = new JAPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(0,10,0,10));


        pnlButtons.setLayout(new GridLayout(5, 1, 10,10));

        pnlButtons.add(theOKButton);
        pnlButtons.add(theCancelButton);

        JAPanel pnlTopButtons = new JAPanel();
        pnlTopButtons.add(pnlButtons);

        pane.add(pnlTopButtons, BorderLayout.EAST);

        setSize(400, 300);
        setLocationRelativeTo(null);

        show(null);
    }

    public boolean execute(MetaObject metaObject, String sPropertyName, SuperDesignCockpit superDesignCockpit)
    {
        new IDEKeyControlEditor( metaObject, sPropertyName, superDesignCockpit );
        return true;
    }


    class OKButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEKeyControlEditor theEditor = null;

        public OKButtonAction(IDEKeyControlEditor theEditor, MetaObject theMetaObject) {
            super("OK");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEKeyControlEditorTable theTable = theEditor.theKeyControlTable;
            IDEKeyControlEditorTableModel theModel = theEditor.theModel;

            theMetaObject= theMetaObject.theFirstChild;
            theMetaObject.theFirstChild = null;
            theMetaObject.theLastChild = null;
            int iRow = 0;

            while (theMetaObject!=null) {
                IDEKeyDescriptor theDescriptor = (IDEKeyDescriptor) theModel.theKeyPages.get(iRow);

                if(!(theMetaObject.getSwingObject() instanceof JSeparator))
                {
                    theDescriptor.theMetaObject.setName(theDescriptor.sName);
                    theDescriptor.theMetaObject = theMetaObject;
                    theDescriptor.theMetaObject.thePreviousObject = theMetaObject.thePreviousObject;
                    theDescriptor.theMetaObject.theNextObject = theMetaObject.theNextObject;

                    KeyStroke ks = KeyStroke.getKeyStroke(theDescriptor.sTitle);
                    if(ks!=null)
                    {
                        theMetaObject.setPropertyValue("Accelerator", 0, 0,theDescriptor.sTitle, true);
                        ((JMenuItem)theMetaObject.theVisualObject).setAccelerator(ks);
                        iRow++;
                    }
                    else
                    {
                        theMetaObject.setPropertyValue("Accelerator", 0, 0,"", true);
                        ((JMenuItem)theMetaObject.theVisualObject).setAccelerator(null);
                        iRow++;
                    }
                }

                theMetaObject = theMetaObject.theNextObject;
            }
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
            theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class CancelButtonAction extends AbstractAction {
        MetaObject theMetaObject = null;
        IDEKeyControlEditor theEditor = null;

        public CancelButtonAction(IDEKeyControlEditor theEditor, MetaObject theMetaObject) {
            super("Cancel");
            this.theMetaObject = theMetaObject;
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
        }
    }

}
