/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class IDEObjectColorChooser {
    SuperDesignCockpit theDesignCockpit;
    JColorChooser theColorChooser = new JColorChooser();
    Color theColor = null;
    public JDialog theDialog = null;

    public IDEObjectColorChooser(SuperDesignCockpit objDesignCockpit, boolean bForeground) {
        theDesignCockpit = objDesignCockpit;
        theColorChooser = new JColorChooser();
        String sCaption;
        if (bForeground)
            sCaption = theDesignCockpit.theLanguageManager.getMessage("ColorDialog.ChooseForegroundColor.label", "Choose Foreground Color");
        else
            sCaption = theDesignCockpit.theLanguageManager.getMessage("ColorDialog.ChooseBackgroundColor.label", "Choose Background Color");

        theDialog = JColorChooser.createDialog(theDesignCockpit.getContentPane(),
                sCaption,
                true,
                theColorChooser,
                new okListener(this, bForeground),
                new cancelListener(this));

        theDialog.show();
    }

    class okListener implements ActionListener {
        IDEObjectColorChooser theColorChooser;
        boolean bForegroundChoice;

        public okListener(IDEObjectColorChooser objColorChooser, boolean bForeground) {
            theColorChooser = objColorChooser;
            bForegroundChoice = bForeground;
        }

        public void actionPerformed(ActionEvent event) {
            theColorChooser.theColor = theColorChooser.theColorChooser.getColor();
            MetaObject theSelectedObject = theColorChooser.theDesignCockpit.getSelectedObject();
            theSelectedObject.setColor(theColorChooser.theColor, bForegroundChoice);
        }
    }

    class cancelListener implements ActionListener {
        IDEObjectColorChooser theColorChooser;

        public cancelListener(IDEObjectColorChooser objColorChooser) {
            theColorChooser = objColorChooser;
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

}
