/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.designcockpit.external.IDEFocusRequester;

import javax.swing.*;
import java.awt.*;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.TooManyListenersException;

/**
 * Title:        uifactory
 * Description:  This is a program design tool that creates Abacus java applications using the UI Factory.  The output of this tool is an xml document that is processed by the UI factory to create the java programs.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */




// View displayer is a bean so that the drag & drop works.

public class IDEViewDisplayer extends JAPanel implements java.io.Serializable {
    Color clrBackground = null;
    private String text = null;
    public SuperDesignCockpit theDesignCockpit = null;
    public int iMouseX = 0;
    public int iMouseY = 0;
    //public String theData;
    private IDEComponentPaletteNode selectedNode;


    IDEObjectPopupMenu thePopupMenu = null;

    public IDEViewDisplayer () {
        super();

        // 20040802, acg, Handle drops from the ComponentPalette
        try {
            setTransferHandler(new TransferHandler("dummy")); // This is a hack to activate DnD in the component.
            getDropTarget().addDropTargetListener(new ComponentDropListener(this, null));
        } catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    public IDEViewDisplayer (SuperDesignCockpit objDesignCockpit) {
        super();
        theDesignCockpit = objDesignCockpit;
        setBackground(clrBackground);
//      ViewDisplayerTransferHandler theTransferHandler = new ViewDisplayerTransferHandler(this);
//      setTransferHandler(theTransferHandler);
        addMouseListener(new IDEViewDisplayerMouseListener(this));
        addMouseMotionListener(new IDEViewDisplayerMouseMotionListener(this));

        // 20040802, acg, Handle drops from the ComponentPalette
        try {
            setTransferHandler(new TransferHandler("dummy")); // This is a hack to activate DnD in the component.
            getDropTarget().addDropTargetListener(new ComponentDropListener(this, null));
        } catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    /**
     * Handle dropping of components
     * acg
     */
    class ComponentDropListener implements DropTargetListener {
        IDEViewDisplayer viewDisplayer;
        MetaObject designObject;
        public ComponentDropListener( IDEViewDisplayer paramViewDisplayer, MetaObject paramDesignObject) {
            super();
            designObject=paramDesignObject;
            viewDisplayer=paramViewDisplayer;
        }
        public void dragEnter(DropTargetDragEvent e) {
        }
        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getSourceActions());
        }
        public void dropActionChanged(DropTargetDragEvent e) {
        }
        public void dragExit(DropTargetEvent e) {
        }
        public void drop(DropTargetDropEvent e) {
            try {
                e.acceptDrop(e.getSourceActions());

                Point pt=e.getLocation();
                Point ptViewDisplayerScreen = getLocationOnScreen();

                /*
                Point pt2=new Point(pt);
                pt2.x+=ptViewDisplayerScreen.x;
                pt2.y+=ptViewDisplayerScreen.y;
                MetaObject theDesignObject=findContainer(null, pt2);
                */

                if ( designObject!=null ) {
                    Point  ptObjectLocation = designObject.theVisualObject.getLocationOnScreen();
                    pt.x += (ptObjectLocation.x - ptViewDisplayerScreen.x);
                    pt.y += (ptObjectLocation.y - ptViewDisplayerScreen.y);
                }

                // if the component to create is actually a Customizer CustomizerDataElementInterface, then create via the Customizer so that sub-elements can be created too...
                IDEComponentPaletteNode selectedNode = theDesignCockpit.theComponentPalettePane.theTree.getSelectedNode();
                if (selectedNode != null) {
                    if (selectedNode.isCustomizerDataElement())
                        theDesignCockpit.theCustomizer.importElement(designObject, pt, false);
                    else
                        theDesignCockpit.theViewDisplayer.importObject(designObject, pt, false, null);
                }

                theDesignCockpit.setMouseSelectState(true);
                if ( designObject!=null ) {
                    IDEFocusRequester.requestFocus(designObject.theVisualObject);
                }

                e.getDropTargetContext().dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                e.rejectDrop();
            }
        }
    }

    public String getText () {
        return text;
    }

    public void initPopupMenu (SuperDesignCockpit objDesignCockpit) {
        thePopupMenu = new IDEObjectPopupMenu(objDesignCockpit);
    }

    public void setText (String sText) {
        text = sText;
    }

    void resetContents () {
        removeAll();
        repaint();
    }

    public MetaObject findContainerByPoint (MetaObject theTestObject, Point pt) {
        while (theTestObject != null) {
            Dimension dimTest = theTestObject.theVisualObject.getSize();
            if (theTestObject.theVisualObject.isShowing()) {
                Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                if ((ptTest.x <= pt.x) &&
                        (ptTest.x + dimTest.getWidth() >= pt.x) &&
                        (ptTest.y <= pt.y) &&
                        (ptTest.y + dimTest.getHeight() >= pt.y)) {
                    // Point is inside this object.  See if it has children.
                    if (theTestObject.theFirstChild != null) {
                        MetaObject theChildObject = findContainerByPoint(theTestObject.theFirstChild, pt);
                        if (theChildObject == null)
                            return theTestObject;  // in client area of container
                        else
                            return theChildObject;  // in child.
                    }
                    return theTestObject;   // no children - it's inside.
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        return null;
    }

    public MetaObject findContainerByPoint (Point pt) {
        if (theDesignCockpit.getSelectedFrame() == null)
            return null;
        MetaObject theSelectedFrame = theDesignCockpit.getSelectedFrame();
        while ((theSelectedFrame.isAbalet() == false) && (theSelectedFrame.isFrame() == false)) {
            theSelectedFrame = theSelectedFrame.theParentObject;
        }
        if (theSelectedFrame == null)
            return null;
        ArrayList theMatchingContainers = new ArrayList(1);
        MetaObject theTestObject = theSelectedFrame.theFirstChild;
        while (theTestObject != null) {
            if ((theTestObject.isGroup()) || (theTestObject.isPanel()) || (theTestObject.isTabbedPane()) || (theTestObject.isTabPage()) || (theTestObject.isScrollPane()) || (theTestObject.isScrollingPanel())) {
                Dimension dimTest = theTestObject.theVisualObject.getSize();
                Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                if ((pt.x >= ptTest.x) &&
                        (pt.x <= dimTest.getWidth() + ptTest.x) &&
                        (pt.y >= ptTest.y) &&
                        (pt.y <= dimTest.getHeight() + ptTest.y)) {
                    // Point is inside this object.  See if it has children.
                    if (theTestObject.theFirstChild != null) {
                        MetaObject theChildContainer = findContainerByPoint(theTestObject.theFirstChild, pt);
                        if (theChildContainer == null) {
//                                theDesignCockpit.theLogFile.doLogEntry("findContainerLocation", "In client area of container:  X: " + pt.x + " Y: " + pt.y);
                            theMatchingContainers.add(theTestObject);  // in client area of container
                        } else {
//                                theDesignCockpit.theLogFile.doLogEntry("findContainerLocation", "In child:  X: " + pt.x + " Y: " + pt.y);
                            theMatchingContainers.add(theChildContainer);  // in child.
                        }
                    }
//                        theDesignCockpit.theLogFile.doLogEntry("findContainerLocation", "No children - it's inside:  X: " + pt.x + " Y: " + pt.y);
                    theMatchingContainers.add(theTestObject);   // no children - it's inside.
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        theMatchingContainers.add(theSelectedFrame);
        MetaObject highestObject = null;
        for (int i = 0; i < theMatchingContainers.size(); i++) {
            MetaObject testObject = (MetaObject) theMatchingContainers.get(i);
            if (highestObject == null)
                highestObject = testObject;
            else {
                if (highestObject.iDisplayLayer < testObject.iDisplayLayer)
                    highestObject = testObject;
            }
        }
        return highestObject;
    }

    public Point findContainerLocation(MetaObject theTestObject, Point pt) {
        while (theTestObject != null) {
            if ((theTestObject.isGroup()) || (theTestObject.isPanel()) || (theTestObject.isTabbedPane()) || (theTestObject.isTabPage()) || (theTestObject.isScrollPane() || (theTestObject.isScrollingPanel()))) {

                if (theTestObject.theVisualObject == null) {
                    this.theDesignCockpit.theLogFile.doLogEntry("Class definition error in find container location", theTestObject.theClass.getMetadata().sClassName);
                    return null;
                }
                Dimension dimTest = theTestObject.theVisualObject.getSize();
                if (theTestObject.theVisualObject.isShowing()) {
                    Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                    if ((ptTest.x <= pt.x) &&
                            (ptTest.x + dimTest.getWidth() >= pt.x) &&
                            (ptTest.y <= pt.y) &&
                            (ptTest.y + dimTest.getHeight() >= pt.y)) {
                        // Point is inside this object.  See if it has children.
                        if (theTestObject.theFirstChild != null) {
                            Point ptCheckChild = findContainerLocation(theTestObject.theFirstChild, pt);
                            if (ptCheckChild == null)
                                return ptTest;  // in client area of container
                            else
                                return ptCheckChild;  // in child.
                        }
                        return ptTest;   // no children - it's inside.
                    }
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        return null;
    }

    public Point findContainerLocation (Point pt) {
        if (theDesignCockpit.getSelectedFrame() == null)
            return null;
        MetaObject theSelectedFrame = theDesignCockpit.getSelectedFrame();
        MetaObject theTestObject = theSelectedFrame.theFirstChild;
        while (theTestObject != null) {
            if ((theTestObject.isGroup()) || (theTestObject.isPanel()) || (theTestObject.isTabbedPane()) || (theTestObject.isTabPage()) || (theTestObject.isScrollPane() || (theTestObject.isScrollingPanel()))) {
                if (theTestObject.theVisualObject == null) {
                    this.theDesignCockpit.theLogFile.doLogEntry("Class definition error in find container location", theTestObject.theClass.getMetadata().sClassName);
                    return null;
                }
                Dimension dimTest = theTestObject.theVisualObject.getSize();
                Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
                if ((pt.x >= ptTest.x) &&
                        (pt.x <= dimTest.getWidth() + ptTest.x) &&
                        (pt.y >= ptTest.y) &&
                        (pt.y <= dimTest.getHeight() + ptTest.y)) {
                    // Point is inside this object.  See if it has children.
                    if (theTestObject.theFirstChild != null) {
                        Point ptCheckChild = findContainerLocation(theTestObject.theFirstChild, pt);
                        if (ptCheckChild == null) {
                            return ptTest;  // in client area of container
                        } else {
                            return ptCheckChild;  // in child.
                        }
                    }
                    return ptTest;   // no children - it's inside.
                }
            }
            theTestObject = theTestObject.theNextObject;
        }
        // If it is an abalet or frame then it is inside the view displayer.
        if ((theSelectedFrame.isAbalet()) || (theSelectedFrame.isFrame())) {
            return getLocationOnScreen();
        } else {       // Check if it is outside of the container.
            theTestObject = theSelectedFrame;
            Dimension dimTest = theTestObject.theVisualObject.getSize();
            Point ptTest = theTestObject.theVisualObject.getLocationOnScreen();
            if ((pt.x >= ptTest.x) &&
                    (pt.x <= dimTest.getWidth() + ptTest.x) &&
                    (pt.y >= ptTest.y) &&
                    (pt.y <= dimTest.getHeight() + ptTest.y)) {
                return ptTest;
            }
            return null;
        }
    }


    public MetaObject importObject (MetaObject theClickedObject, Point ptLocation, boolean bShiftDown, CustomizerDataElementInterface dataElement) {
        theDesignCockpit.allowDragging(false);
        if ((theClickedObject != null) && (theClickedObject.isTabbedPane())) {
            DesignTabbedPane theTabbedPane = (DesignTabbedPane) theClickedObject.theVisualObject;
            int iSelectedIndex = theTabbedPane.getSelectedIndex();
            if ((iSelectedIndex == -1) && (theClickedObject.theFirstChild != null))
                iSelectedIndex = 0;
            if (iSelectedIndex != -1) {
                int iPage = 0;
                MetaObject testPage = theClickedObject.theFirstChild;
                while (testPage != null) {
                    if (iPage == iSelectedIndex) {
                        theClickedObject = testPage;
                        break;
                    }
                    iPage++;
                    testPage = testPage.theNextObject;
                }
            }
        }
        theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        if (!bShiftDown)
            selectedNode = theDesignCockpit.theComponentPalettePane.theTree.getSelectedNode();
        if (selectedNode != null) {
            // Get the size and location from the drop point.
            // Adjust for origin of any embedded container.
            Point ptScreenLocation = getLocationOnScreen();
            ptScreenLocation.x += ptLocation.x;
            ptScreenLocation.y += ptLocation.y;
            // Get object at point that is dropped.
            MetaObject theContainer = null;
            if (theClickedObject != null)
                theContainer = theClickedObject.getVisualContainerObject(false);
            if (theContainer != null) {
                theDesignCockpit.SelectObject(theContainer, false);
                theDesignCockpit.SelectContainer(theContainer);
                // if the container is a child of a split pane we need to adjust for
                // the divider position.
                MetaObject testContainer = theContainer;
                JComponent childTestComponent = this;
                int splitx = 0;
                int splity = 0;
                while (testContainer != null) {
                    if (testContainer.isHorzSplit()) {
                        JSplitPane splitter = (JSplitPane) testContainer.theVisualObject;
                        if (splitter.getRightComponent().equals(childTestComponent))
                            splitx += splitter.getDividerLocation();
                    } else if (testContainer.isVertSplit()) {
                        JSplitPane splitter = (JSplitPane) testContainer.theVisualObject;
                        if (splitter.getBottomComponent().equals(childTestComponent))
                            splity += splitter.getDividerLocation();
                    }
                    childTestComponent = testContainer.theVisualObject;
                    testContainer = testContainer.theParentObject;
                }
                ptScreenLocation.x -= splitx;
                ptScreenLocation.y -= splity;
            }
            Point ptContainerLocation = findContainerLocation(ptScreenLocation);
            if (ptContainerLocation != null) {
                ptLocation.x = ptScreenLocation.x - ptContainerLocation.x;
                ptLocation.y = ptScreenLocation.y - ptContainerLocation.y;
//                theDesignCockpit.theLogFile.doLogEntry("Dropping Obj", "X: " + ptLocation.x + " Y: " + ptLocation.y);
            }
            String sClassToCreate;
            if (dataElement == null)
                sClassToCreate = selectedNode.getMetaClass().getMetadata().sClassName;
            else {
                sClassToCreate = theDesignCockpit.theCustomizer.getImplementingClass(dataElement);
            }

            MetaObject theMetaObject = addObject(sClassToCreate, dataElement);
            // Adjust location.
            if (theMetaObject != null) {
                if (theMetaObject.theVisualObject != null) {
                    if (theDesignCockpit.getDesignProject() != null)
                        theDesignCockpit.getDesignProject().theUndoRedoController.createImportObjectEvent(theMetaObject,
                                theMetaObject.theParentObject);
                    Dimension dimSize = theMetaObject.theVisualObject.getSize();
                    // Set size and location at drop point and normalize through alignment of view displayer.
                    // 7/2/2003 - changed this by request of hervo to maintain defaults even if not on grid
                    if (theMetaObject.theParentObject != null) {
                        Dimension dimParentSize = theMetaObject.theParentObject.getSize();
                        Dimension dimNewSize = dimSize;
                        if (dimParentSize.width < (dimSize.width + ptLocation.x))
                            dimNewSize.width = dimParentSize.width - ptLocation.x;
                        if (dimParentSize.height < (dimSize.height + ptLocation.y))
                            dimNewSize.height = dimParentSize.height - ptLocation.y;
                    }
                    theDesignCockpit.resizeAction(theMetaObject, (int) ptLocation.getX(),
                            (int) ptLocation.getY(),
                            (int) dimSize.getWidth(),
                            (int) dimSize.getHeight(),
                            MetaObject.RESIZE_CONTEXT_IMPORT_OBJECT,
                            true, true);
                    // Read back the properties.
                    ptLocation = theMetaObject.getLocation();
                    dimSize = theMetaObject.getSize();
                    // Set the visual component to the normalized values.
                    if ((((theMetaObject.isAbalet() == true) || (theMetaObject.isFrame() == true))
                            && (theMetaObject.iMode == MetaObject.DESIGN_MODE)) ||
                            (theMetaObject.theParentObject.isScrollPane()))
                        theMetaObject.setLocation(0, 0);
                    else
                        theMetaObject.theVisualObject.setLocation((int) ptLocation.getX(), (int) ptLocation.getY());
                    theMetaObject.theVisualObject.setSize((int) dimSize.getWidth(), (int) dimSize.getHeight());
                    // If it is a container, select the container as the current container.
                    if (theMetaObject.isPanel() || theMetaObject.isTabbedPane() ||
                            theMetaObject.isGroup() ||
                            theMetaObject.isScrollPane() || theMetaObject.isTabPage() || theMetaObject.isScrollingPanel())
                        theDesignCockpit.SelectContainer(theMetaObject, true);
                    theDesignCockpit.getDesignProject().deselectObjects();
                    // Select the object to get the size box.
                    theDesignCockpit.SelectObject(theMetaObject, false);
                }  // allow non visual objects to be added without giving an error.
                theDesignCockpit.theComponentPalettePane.theTree.setSelectionInterval(0, 0);

                if (theDesignCockpit.isCustomizing()){
                    if ( dataElement != null){ //might be a not customizer-specific class
                      theDesignCockpit.theCustomizer.newInstanceCreated(dataElement, theMetaObject);
                    }
                }

                // acg: Manage listeners for late binding components (eg. customizer).
                if ( theMetaObject.isCompositeComponent() )
                {
                    theMetaObject.refreshListeners();
                }

                return theMetaObject;
            } else {
                theDesignCockpit.allowDragging(true);
                return null;
            }
        }
        theDesignCockpit.allowDragging(true);
        return null;
    }

    public boolean testObject (MetaObject theMetaObject) {
//        MetaClass theClass = theMetaObject.theClass;
        if (theMetaObject.theVisualObject == null) { // non visual objects can be on top.
            return true;
        }
        // Set the selected frame or add the object to the view displayer or embedded container.
        int iContainerType = theMetaObject.theClass.getMetadata().containerType.getContainerType();
        MetaObject theParent = theMetaObject.theParentObject;
        if ((theParent != null) && (theParent.theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_TABBEDPANE)) {
            if (iContainerType != MetaContainerType.CONTAINER_TABPAGE)
                return false;
            else
                return true;
        }
        if (iContainerType == MetaContainerType.CONTAINER_TABPAGE)
            return false;
        if ((iContainerType != MetaContainerType.CONTAINER_FRAME) &&
                (iContainerType != MetaContainerType.CONTAINER_ABALET)) {
            // It could be we need to add this control to its parent container.
            if (theParent == null) {  // The object cannot be a top level window.
                return false;
            }
        } else {
            if (theParent != null) {  // The object cannot be a top level window.
                return false;
            }
        }
        return true;
    }

    public void displayObjects (MetaObject currObj) {
        displayObject(currObj);
        currObj = currObj.theFirstChild;
        while (currObj != null) {
            displayObjects(currObj);
            currObj = currObj.theNextObject;
        }
    }

    public void removeHammerComponentKeyInterfaces (Component comp, IDEViewDisplayerComponentKeyListener theNewListener) {
        KeyListener[] theListeners = comp.getKeyListeners();
        for (int iListener = 0; iListener < theListeners.length; iListener++) {
            comp.removeKeyListener(theListeners[iListener]);
        }
        if (comp instanceof Container) {
            int iCompCount = ((Container) comp).getComponentCount();
            if (iCompCount > 0) {
                Component[] theComponents = ((Container) comp).getComponents();
                for (int iComponent = 0; iComponent < iCompCount; iComponent++) {
                    Component childComp = theComponents[iComponent];
                    this.removeHammerComponentKeyInterfaces(childComp, theNewListener);
                }
            }
        }
        comp.setFocusable(true);
        comp.setEnabled(true);
        comp.addKeyListener(theNewListener);
    }

    public void setKeyboardInterface (MetaObject theObject) {
        Component comp = theObject.theVisualObject;
        IDEViewDisplayerComponentKeyListener theNewListener = new IDEViewDisplayerComponentKeyListener(theObject);
        removeHammerComponentKeyInterfaces(comp, theNewListener);
//        IDEViewDisplayerComponentFocusListener theFocusListener = new IDEViewDisplayerComponentFocusListener(this);

        // Some special hacks for the Designer to make it look like stuffs not active.
        if (comp instanceof JButton) {
            ((JButton) comp).setFocusPainted(false);
        }
        if (comp instanceof JTextArea) {
            ((JTextArea) comp).setEditable(false);
        }
        if (comp instanceof JTextField) {
            ((JTextField) comp).setEditable(false);
        }

    }

    //  This is the central method that adds visual objects to the view displayer.
    public boolean displayObject (MetaObject theMetaObject) {
//        MetaClass theClass = theMetaObject.theClass;
        if (theMetaObject.theVisualObject == null) { // no reason to add it.
            return true;
        }

        // Set the selected frame or add the object to the view displayer or embedded container.
        int iContainerType = theMetaObject.theClass.getMetadata().containerType.getContainerType();
        if ((iContainerType == MetaContainerType.CONTAINER_ABALET) ||
                (iContainerType == MetaContainerType.CONTAINER_FRAME) ||
                (iContainerType == MetaContainerType.CONTAINER_BUTTONGROUP) ||
                (iContainerType == MetaContainerType.CONTAINER_SCROLLING_PANEL) ||
                (iContainerType == MetaContainerType.CONTAINER_PANEL) ||
                (iContainerType == MetaContainerType.CONTAINER_TABPAGE)) {
            DesignAnchoringLayoutManager theAnchoringLayout = new DesignAnchoringLayoutManager(theMetaObject, theDesignCockpit);
            theMetaObject.theLayoutManager = theAnchoringLayout;
            theMetaObject.theVisualObject.setLayout(theAnchoringLayout);

            // 20040802, acg, Handle drops from the ComponentPalette
            try {
                theMetaObject.theVisualObject.setTransferHandler(new TransferHandler("dummy")); // This is a hack to activate DnD in the component.
                theMetaObject.theVisualObject.getDropTarget().addDropTargetListener(new ComponentDropListener(this, theMetaObject));
            } catch (TooManyListenersException e) {
                e.printStackTrace();
            }
        }
        // Listeners
        setKeyboardInterface(theMetaObject);
        if ((iContainerType != MetaContainerType.CONTAINER_ABALET) &&
                (iContainerType != MetaContainerType.CONTAINER_FRAME) &&
                (iContainerType != MetaContainerType.CONTAINER_HSPLIT) &&
                (iContainerType != MetaContainerType.CONTAINER_VSPLIT)) {
            if (iContainerType == MetaContainerType.CONTAINER_TABPAGE) {
                // Tab pages move the tab dialog.
                theMetaObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theMetaObject, theMetaObject.theParentObject, theDesignCockpit, theMetaObject.theVisualObject);
                theMetaObject.theMouseMotionListener = new IDEViewDisplayerComponentMouseMotionListener(theMetaObject.theParentObject,
                        theMetaObject.theParentObject.theVisualObject, theDesignCockpit);
            } else { // controls need to turn off their mouse interface.
                theMetaObject.removeListeners();
                theMetaObject.theMouseMotionListener = new IDEViewDisplayerComponentMouseMotionListener(theMetaObject, theMetaObject.theVisualObject, theDesignCockpit);
                theMetaObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theMetaObject, theMetaObject, theDesignCockpit, theMetaObject.theVisualObject);
            }
        } else {
            theMetaObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theMetaObject, theMetaObject, theDesignCockpit, theMetaObject.theVisualObject);
            theMetaObject.theMouseMotionListener = null;
        }

        //#ALEX: Code moved to MetaObject so it can also be called in Customizer
        theMetaObject.refreshListeners ( );
//        if (theMetaObject.theMouseListener != null)
//            theMetaObject.theVisualObject.addMouseListener((IDEViewDisplayerComponentMouseListener) theMetaObject.theMouseListener);
//        if (theMetaObject.theMouseMotionListener != null)
//            theMetaObject.theVisualObject.addMouseMotionListener((IDEViewDisplayerComponentMouseMotionListener) theMetaObject.theMouseMotionListener);

        if ((iContainerType != MetaContainerType.CONTAINER_FRAME) &&
                (iContainerType != MetaContainerType.CONTAINER_ABALET)) {
            // It could be we need to add this control to its parent container.
            MetaObject theParent = theMetaObject.theParentObject;
            if (theParent == null) {  // This object cannot be a top level window.
                return false;
            } else {
                int iParentContainerType = theParent.theClass.getMetadata().containerType.getContainerType();
                // Radio buttons need to be added to group and container!
                if (iParentContainerType == MetaContainerType.CONTAINER_BUTTONGROUP) {
//                    ((ButtonGroup) theParent.theFabricatedObject).add((AbstractButton) theMetaObject.theVisualObject);
//                    theParent = theParent.theParentObject;
//                    iParentContainerType = theParent.theClass.getMetadata().containerType.getContainerType();
                    ButtonGroup theButtonGroup = theParent.getButtonGroup();
                    if (theButtonGroup != null) {
                        if (theMetaObject.theVisualObject instanceof AbstractButton)
                            theButtonGroup.add((AbstractButton) theMetaObject.theVisualObject);
                    }
                }
                if ((iContainerType == MetaContainerType.CONTAINER_TABPAGE) &&
                        (iParentContainerType != MetaContainerType.CONTAINER_TABBEDPANE)) {
                    JOptionPane pane = new JOptionPane("Tab page only allowed within tabbed pane");
                    JDialog dialog = pane.createDialog(theDesignCockpit, "Component Selection Error");
                    dialog.show();
                    return false;
                }
                if (iParentContainerType == MetaContainerType.CONTAINER_NONE)  // This is an error in metadata.
                    add(theMetaObject.theVisualObject, theMetaObject);  // try to recovert the best we can
                else { // Tab Pages, Panels & scrollpanes just get controls added to the view displayer.
                    if ((iContainerType != MetaContainerType.CONTAINER_FRAME) &&
                            (iContainerType != MetaContainerType.CONTAINER_ABALET))
                        theMetaObject.setPropertyValue("Attached", 0, 0, new Boolean(true), false);
                    if (iParentContainerType == MetaContainerType.CONTAINER_SCROLLPANE) {
                        JAScrollPane theScrollPane = (JAScrollPane) theParent.theVisualObject;
//                      theScrollPane.setViewportView(theMetaObject.theVisualObject);
                        theScrollPane.setLayout(null);
                        theMetaObject.theLayoutManager = null;
                        theMetaObject.setPropertyValue("Location.Left", 0, 0, "0", true);//theParent.theObject.getProperty("Left",0));
                        theMetaObject.setPropertyValue("Location.Top", 0, 1, "0", true);//theParent.theObject.getProperty("Top", 0));
                        theMetaObject.setPropertyValue("Size.Width", 0, 0, theParent.getPropertyValue("Size.Width", 0), true);
                        theMetaObject.setPropertyValue("Size.Height", 0, 1, theParent.getPropertyValue("Size.Height", 0), true);
                        if (theMetaObject.theVisualObject != null) {
                            theMetaObject.doProperties();
                        }
                        theScrollPane.add(theMetaObject.theVisualObject);
                    } else { // If parent is a tab page or panel, add the control to it.
                        if (theMetaObject.theVisualObject != null) {
                            theMetaObject.doProperties();
                        }
                        if (iParentContainerType == MetaContainerType.CONTAINER_TABBEDPANE) {
                            // If we have a tabbed pane parent, add this tab page to the tabbed pane.
                            theMetaObject.setPropertyValue("Location.Left", 0, 0, "0", true);//theParent.theObject.getProperty("Left",0));
                            theMetaObject.setPropertyValue("Location.Top", 0, 1, "0", true);//theParent.theObject.getProperty("Top", 0));
                            Dimension theSize = theParent.getSize();
                            theMetaObject.setPropertyValue("Size.Width", 0, 0, theSize.width, true);
                            theMetaObject.setPropertyValue("Size.Height", 0, 1, theSize.height, true);
                            if (theParent.theVisualObject instanceof DesignTabbedPane) {
                                DesignTabbedPane theTabbedPane = (DesignTabbedPane) theParent.theVisualObject;
                                if (theMetaObject.theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_TABPAGE) {
                                    int iIndex = theTabbedPane.indexOfComponent(theMetaObject.theVisualObject);
                                    if (iIndex == -1) {
                                        iIndex = theParent.getChildIndex(theMetaObject);
                                        MetaPropertyValueEx theTabTitle = theParent.getPropertyValue("TabTitle", iIndex);
                                        if (theTabTitle == null)
                                            theTabbedPane.addTab("tab", theMetaObject.theVisualObject);
                                        else
                                            theTabbedPane.addTab(theTabTitle.getStringValue(), theMetaObject.theVisualObject);
                                    } //else { // SWB: commented-out to select the first tabpage when the project is loaded
                                    //    int iTestIndex = theTabbedPane.getSelectedIndex();
                                    //    if (iTestIndex != iIndex)
                                    //        theTabbedPane.setSelectedIndex(iIndex);
                                    //}
                                } else
                                    System.out.println("Serious error - Child of tabbed pane should be a tab page.");
                            } else  // This is actually a serious error!
                                System.out.println("Serious error - Tabbed Pane class should be defined with tabbed pane display object");
                        }
                        else if (iParentContainerType == MetaContainerType.CONTAINER_JMENUBAR) { // #MHC Action bar menu
                              if (theParent.theVisualObject instanceof JMenuBar) {
                                      JMenuBar jm = (JMenuBar)theParent.theVisualObject;
                                      JMenu ji = (JMenu)theMetaObject.getSwingObject();
                                      jm.add(ji);
                             }
                        }
                        else if (iParentContainerType == MetaContainerType.CONTAINER_JMENU) { // #MHC Action bar menu
                              if (theParent.theVisualObject instanceof JMenu) {
                                      JMenu jm = (JMenu)theParent.theVisualObject;
                                      if( theMetaObject.getSwingObject() instanceof JMenuItem )
                                      {
                                        JMenuItem ji = (JMenuItem)theMetaObject.getSwingObject();
                                         jm.add(ji);
                                      }
                                      else if (theMetaObject.getSwingObject() instanceof JSeparator)
                                      {
                                        JSeparator js = (JSeparator)theMetaObject.getSwingObject();
                                        jm.add(js);
                                      }
                              }
                         }
                        else if (iParentContainerType == MetaContainerType.CONTAINER_JTOOLBAR) { // #MHC For Tool Bar implementation
                              if (theParent.theVisualObject instanceof JToolBar) {
                                      JToolBar jm = (JToolBar)theParent.theVisualObject;
                                      jm.setFloatable(false);
                                      JButton ji = (JButton)theMetaObject.getSwingObject();
                                      Dimension theSize = theMetaObject.getSize();
                                      theMetaObject.setPropertyValue("Size.Width", 0, 0, theSize.width, true);
                                      theMetaObject.setPropertyValue("Size.Height", 0, 1, theSize.height, true);

                                      jm.add(ji);
                                      jm.updateUI();
                             }
                        }
                        else if ((iParentContainerType == MetaContainerType.CONTAINER_HSPLIT) || (iParentContainerType == MetaContainerType.CONTAINER_VSPLIT)) {
                            MetaObject objGrandparent = theParent.theParentObject;
                            Dimension theSize = objGrandparent.getSize();
                            theMetaObject.setPropertyValue("Size.Width", 0, 0, theSize.width, true);
                            theMetaObject.setPropertyValue("Size.Height", 0, 1, theSize.height, true);
                            JSplitPane theParentContainer = (JSplitPane) theParent.theVisualObject;
                            int iIndex = theParent.getChildIndex(theMetaObject);
                            if (iIndex == 0) {
                                if (theParentContainer.getOrientation() == JSplitPane.VERTICAL_SPLIT)
                                    theParentContainer.setLeftComponent(theMetaObject.theVisualObject);
                                else
                                    theParentContainer.setTopComponent(theMetaObject.theVisualObject);
                            } else {
                                if (theParentContainer.getOrientation() == JSplitPane.VERTICAL_SPLIT)
                                    theParentContainer.setRightComponent(theMetaObject.theVisualObject);
                                else
                                    theParentContainer.setBottomComponent(theMetaObject.theVisualObject);
                            }
                        } else { // Panel & Tab Page & Frame & Abalet.
                            // Anchoring layout manager.
                            if (theParent.theLayoutManager instanceof DesignAnchoringLayoutManager) {
                                DesignAnchoringLayoutManager theLayoutManager = (DesignAnchoringLayoutManager) theParent.theLayoutManager;
                                JComponent theContainer = theParent.theVisualObject;
                                if (theContainer instanceof JLayeredPane) {
                                    JLayeredPane thePane = (JLayeredPane) theContainer;
                                    thePane.add(theMetaObject.theVisualObject, theMetaObject.getName(), JLayeredPane.DEFAULT_LAYER.intValue());
                                } else
                                    theContainer.add(theMetaObject.theVisualObject, theMetaObject.getName());
                                theLayoutManager.setAnchoring(theMetaObject.theVisualObject,
                                        theMetaObject,
                                        theMetaObject.getAnchorLeft(),
                                        theMetaObject.getAnchorRight(),
                                        theMetaObject.getAnchorTop(),
                                        theMetaObject.getAnchorBottom());
                            }
                        }
                    }
                }
            }
        } else
            theDesignCockpit.SelectContainer(theMetaObject, true);
        return true;
    }


    // Executed when selecting a frame from the object tree view.
    boolean addObjects (MetaObject theMetaObject) {
        if ((!theMetaObject.isFrame()) && (!theMetaObject.isAbalet())) {
            // Create the visual object (or fabricated object) if it doesn't already exist.
            if (theMetaObject.theFabricatedObject == null) {
                theMetaObject.iMode = MetaObject.DESIGN_MODE;
                theMetaObject.create();
            }
            if (displayObject(theMetaObject) == false)
                return false;
        }
        // Add child objects.
        MetaObject theChildObject = theMetaObject.theFirstChild;
        while (theChildObject != null) {
            if ((!theChildObject.isFrame()) && (!theChildObject.isAbalet()))
                addObjects(theChildObject);
            theChildObject = theChildObject.theNextObject;
        }
        return true;
    }

    void add (JComponent component, MetaObject theObject) {
        theObject.setPropertyValue("Attached", 0, 0, new Boolean(true), false);
        if (theObject.theVisualObject != null) {
            theObject.doProperties();
        }
    }


    //  Dropped in from the component palette. Import or add tab pane.
    MetaObject addObject (String sClassName, CustomizerDataElementInterface dataElement) {
        if ((sClassName != null) && (sClassName.trim().length() != 0)) {
            String sNewObjectName = "";
            MetaProject theDesignProject = theDesignCockpit.getDesignProject().theMetaProject;
            MetaClass theClass = theDesignProject.findClass(sClassName);
            if (theClass == null)
                return null;
            // Get a unique object name for this class in the selected frame.
            sNewObjectName = theDesignCockpit.getDesignProject().getNewObjectName(theClass.getMetadata().sClassName);
            MetaObject theMetaObject = theClass.Create(sNewObjectName, theDesignCockpit.getDesignProject().theMetaProject, false);

            theMetaObject.iMode = MetaObject.DESIGN_MODE;
            theMetaObject.theClass = theClass;

            if (theClass.getMetadata().containerType.getContainerType() != MetaContainerType.CONTAINER_NONE)
                theMetaObject.setPropertyValue("ContainerType", 0, 0,
                        new String(theClass.getMetadata().containerType.getContainerTypeAsString()), false);
            if(!theMetaObject.isJMenuBar()) // #MHC Do not set Text on the MenuBar -- No can do!
                theMetaObject.setPropertyValue("Text", 0, 0, sNewObjectName, true);
            // Set initial location.
            if (theMetaObject.isAbalet() || theMetaObject.isFrame()) {
                theMetaObject.setPropertyValue("Location.Left", 0, 0, 0, true);///new Integer(0).toString() );
                theMetaObject.setPropertyValue("Location.Top", 0, 1, 0, true);///new Integer(0).toString() );
            }
            else if (theMetaObject.isJMenuBar()) { // #MHC For action bar menu support
                theMetaObject.setPropertyValue("Location.Left", 0, 0, 0, true);
                theMetaObject.setPropertyValue("Location.Top", 0, 1, 0, true);
            }
            else if (theMetaObject.isJMenu()||theMetaObject.isJMenuItem() || theMetaObject.isJMenuSeparator()
                || theMetaObject.isJToolBarButton()) { // #MHC For menu support , we do not need location, just add it to the menu.
            }
            else {
                theMetaObject.setPropertyValue("Location.Left", 0, 0, iMouseX, false);///new Integer(iMouseX).toString() );
                theMetaObject.setPropertyValue("Location.Top", 0, 1, iMouseY, false);///new Integer(iMouseY).toString());
            }

            theMetaObject.psText = sNewObjectName;
            theMetaObject.iMode = MetaObject.DESIGN_MODE;
            // Create sets up and displays the object in its container.
            if (create(theMetaObject)) {
                if (theDesignCockpit.isCustomizing()) {
                    theDesignCockpit.theCustomizer.setProperties(theMetaObject, dataElement);
                    theMetaObject.refresh();
                }
                return theMetaObject;
            }
        }
        return null;
    }

    public boolean create (MetaObject theMetaObject) {
        boolean bTest1 = theMetaObject.create();
        if (bTest1) {
            // Tell the ObjectTreeView to add it.
            boolean bTest2 = testObject(theMetaObject);
            if (bTest2 == true) {
                // Add to the selected frame.
                theDesignCockpit.theObjectTreeViewPane.addObject(theMetaObject, theMetaObject.theParentObject);
                displayObject(theMetaObject);
                return true;
            } else {
                theMetaObject.DeleteObject(theDesignCockpit.theCurrentDesignProject.theMetaProject, theDesignCockpit);
                return false;
            }
        }
        return false;
    }

    void setMouseCoordinates (int x, int y) {
        iMouseX = x;
        iMouseY = y;
    }

    Color getAppropriateColor (Color theColor) {
        Color newColor = new Color((theColor.getRed() + 128) % 256,
                (theColor.getGreen() + 128) % 256,
                (theColor.getBlue() + 128) % 256);
        return newColor;
    }

    public void paintComponent (Graphics g) {
        Dimension theSize = getSize();
        if ((theDesignCockpit != null) && (theDesignCockpit.getDesignProject() != null) && (theDesignCockpit.getDesignProject().getSelectedFrame() != null)) {
            MetaObject theSelectedFrame = theDesignCockpit.getDesignProject().getSelectedFrame();
            // Use the frame or abalet for the view displayer always, even if a tabbed pane is selected.
            while ((theSelectedFrame != null) && (theSelectedFrame.isFrame() == false) && (theSelectedFrame.isAbalet() == false))
                theSelectedFrame = theSelectedFrame.theParentObject;
            Dimension theAbaletSize = theSelectedFrame.getSize();

            Color theColor = theSelectedFrame.getBackgroundColor();

            if (theColor == null)
                theColor = new Color(160, 160, 160);

            g.setColor(theColor);
            g.fillRect(0, 0, (int) theAbaletSize.getWidth() - 1, (int) theAbaletSize.getHeight() - 1);
            if (theSize.getWidth() - theAbaletSize.getWidth() > 0) {
                g.setColor(this.getBackground ());
                g.fillRect((int) theAbaletSize.getWidth(), 0,
                        (int) theSize.getWidth() - (int) theAbaletSize.getWidth(),
                        (int) theSize.getHeight());
            }
            if (theSize.getHeight() - theAbaletSize.getHeight() > 0) {
                g.setColor(this.getBackground ());
                g.fillRect(0, (int) theAbaletSize.getHeight(),
                        (int) theAbaletSize.getWidth(),
                        (int) theSize.getHeight() - (int) theAbaletSize.getHeight());
            }

            // draw the grid...

            //#ALEX, Small UI mod
            if (theDesignCockpit.thePreferences.bDisplayBackgroundGrid) {
                Color thePenColor = getAppropriateColor(theColor);
                g.setColor(thePenColor);

                int y = theDesignCockpit.thePreferences.iViewDisplayerGridY;
                int x = theDesignCockpit.thePreferences.iViewDisplayerGridX;
                int cx = (int) theSize.getWidth();
                int cy = (int) theSize.getHeight();
                while (y < cy) {
                    g.drawLine(0, y, cx - 1, y);
                    y += theDesignCockpit.thePreferences.iViewDisplayerGridY;
                }
                while (x < cx) {
                    g.drawLine(x, 0, x, cy - 1);
                    x += theDesignCockpit.thePreferences.iViewDisplayerGridX;
                }
            }


        } else {
            g.setColor(this.getBackground ());
            g.fillRect(0, 0, (int) theSize.getWidth() - 1, (int) theSize.getHeight() - 1);
        }
    }


}


