/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * IDEWindowClosedEventHandler
 *
 * This is how the design cockpit exits.  When the design cockpit is run standalone,
 * the design cockpit just exits with a call to System.exit().  When run from another
 * program, we just return control to the caller.
 *
 * Dejan suggested that we have two adapters - one for closing and one for closed.
 *
 */
public class IDEWindowClosedEventHandler extends WindowAdapter {
    SuperDesignCockpit theDesignCockpit;

    public IDEWindowClosedEventHandler(SuperDesignCockpit objDesignCockpit) {
        super();
        theDesignCockpit = objDesignCockpit;
    }

    public void windowClosed(WindowEvent evt) {
        // Stand alone apps should set the bStartedFromExternalProgram boolean flag
        // to keep the system from exiting.  Global interface is set by abacus
        // menu and will never exit.  Only standalone design cockpit should invoke exit!
        if ((theDesignCockpit.bStartedFromExternalProgram == false) &&
                (theDesignCockpit.theGlobalInterface == null))
            System.exit(0);
    }
}
