/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  MruMenu.java
 *
 * Creator:
 * 29.12.2003 15:33:54 vegh
 *
 * Maintainer:
 * 29.12.2003 15:33:54 vegh
 *
 * Last Modification:
 * $Id: MruMenu.java,v 1.1 2004/06/16 08:54:07 vegh Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.designcockpit.ide;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.io.File;

public abstract class MruMenu extends JMenu implements MruMenuListener{


    public MruList mruList;

    public MruMenu(String s, MruList mruList) {
        super(s);
        this.mruList = mruList;
        mruList.setMruMenu(this);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource() ;
        String sFilePath = item.getToolTipText(); // the full filename is stored in the tooltip
        File file = new File(sFilePath);
        String sFileTitle = file.getName();
        actionPerformed(new MruMenuEvent(e.getSource(), e.getID(), e.getActionCommand(), sFileTitle, sFilePath));
    }
}

