/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


class SizeboxMouseListener implements MouseListener {
    Sizebox theSizebox = null;
    Cursor savedCursor1 = null;
    Cursor savedCursor2 = null;
    Cursor savedCursor3 = null;

    public SizeboxMouseListener(Sizebox objSizebox) {
        theSizebox = objSizebox;
    }

    Cursor getSizeboxCursor() {
        if (theSizebox.theOrientation == Sizebox.NORTH)
            return new Cursor(Cursor.N_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.SOUTH)
            return new Cursor(Cursor.S_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.NORTHWEST)
            return new Cursor(Cursor.NW_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.NORTHEAST)
            return new Cursor(Cursor.NE_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.SOUTHWEST)
            return new Cursor(Cursor.SW_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.SOUTHEAST)
            return new Cursor(Cursor.SE_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.EAST)
            return new Cursor(Cursor.E_RESIZE_CURSOR);
        else if (theSizebox.theOrientation == Sizebox.WEST)
            return new Cursor(Cursor.W_RESIZE_CURSOR);
        return null;
    }

    public void mouseClicked(MouseEvent evt) {
          //System.out.println("Clicked Inside the window!");
    }

    public void mouseEntered(MouseEvent evt) {
//          savedCursor1 = theSizebox.getCursor();
        theSizebox.setCursor(getSizeboxCursor()); // don't need to save old cursor for this
//          System.out.println("Entered the window!");
    }

    public void mouseExited(MouseEvent evt) {
//          theSizebox.setCursor(savedCursor1);  // don't need to save old cursor for this
//          System.out.println("Exited the window!");
    }

    public void mousePressed(MouseEvent evt) {
        theSizebox.ptDragFrom = evt.getPoint();
        MetaObject theSelectedContainer =
                theSizebox.theDesignCockpit.getSelectedContainer();

        MetaObject metaParent = theSizebox.theMetaObject.theParentObject;
        if (metaParent != null) {
            LayoutManager lm = metaParent.getLayoutManager();
            if (lm != null && lm instanceof DesignAnchoringLayoutManager) {
                ((DesignAnchoringLayoutManager)(lm)).bAnchoringEnabled = false; // disable anchoring until mouseReleased()
            }
        }


        // save container cursor.
        if ((theSelectedContainer != null) && (theSelectedContainer.theVisualObject != null)) {
            savedCursor2 = theSelectedContainer.theVisualObject.getCursor();
            theSelectedContainer.theVisualObject.setCursor(getSizeboxCursor());
        }
        // save view displayer cursor.
        savedCursor3 = theSizebox.theDesignCockpit.theViewDisplayer.getCursor();
        theSizebox.theDesignCockpit.theViewDisplayer.setCursor(getSizeboxCursor());
    }

    public void mouseReleased(MouseEvent evt) {
        // restore cursor for container and view displayer.
        MetaObject theSelectedContainer =
                theSizebox.theDesignCockpit.getSelectedContainer();

        MetaObject metaParent = theSizebox.theMetaObject.theParentObject;
        if (metaParent != null) {
            LayoutManager lm = metaParent.getLayoutManager();
            if (lm != null && lm instanceof DesignAnchoringLayoutManager) {
                ((DesignAnchoringLayoutManager)(lm)).bAnchoringEnabled = true; // re-enable anchoring that was disabled during mousePressed()
            }
        }
        theSizebox.theMetaObject.bAnchoringOff = true;


        if ((theSelectedContainer != null) && (theSelectedContainer.theVisualObject != null))
            theSelectedContainer.theVisualObject.setCursor(savedCursor2);
        theSizebox.theDesignCockpit.theViewDisplayer.setCursor(savedCursor3);
        savedCursor2 = null;
        savedCursor3 = null;
        Component comp = theSizebox.theMetaObject.theVisualObject;
        if (comp != null) {
            Point pt = comp.getLocation();
            Dimension dimSize = comp.getSize();
            // done dragging. align!
            boolean bResizeHorizontal = theSizebox.isResizingHorizontal();
            boolean bResizeVertical = theSizebox.isResizingVertical();
            theSizebox.theController.relocate(pt.x, pt.y, (int) dimSize.getWidth(), (int) dimSize.getHeight(), false, bResizeHorizontal, bResizeVertical);
            if (theSizebox.theController.theMetaObject.bResizing)
                theSizebox.endResizing(theSizebox.theController.theMetaObject);
        }
    }

    public void kill() {
        MetaObject theSelectedContainer =
                theSizebox.theDesignCockpit.getSelectedContainer();
        if ((theSelectedContainer != null) && (theSelectedContainer.theVisualObject != null))
            theSelectedContainer.theVisualObject.setCursor(savedCursor2);
        if (theSizebox.theDesignCockpit.theViewDisplayer != null)
            theSizebox.theDesignCockpit.theViewDisplayer.setCursor(savedCursor3);
        savedCursor2 = null;
        savedCursor3 = null;
    }

}


class SizeboxMouseMotionListener implements MouseMotionListener {
    Sizebox theSizebox = null;

    public SizeboxMouseMotionListener(Sizebox objSizebox) {
        theSizebox = objSizebox;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        theSizebox.dragAction(e);
    }
}

public class Sizebox extends Box {
    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHWEST = 5;
    public static final int WEST = 6;
    public static final int NORTHWEST = 7;
    public int theOrientation = NORTH;
    public MetaObject theMetaObject = null;
    public int width = 4;
    public int height = 4;
    public Point ptDragFrom = null;
    SizeboxMouseMotionListener theMouseMotionListener = null;
    SizeboxMouseListener theMouseListener = null;
    Sizeboxes theController = null;
    public SuperDesignCockpit theDesignCockpit = null;

    public Sizebox(MetaObject objMetaObject, int iOrientation, Sizeboxes objController, SuperDesignCockpit theDesignCockpit) {
        super(BoxLayout.X_AXIS);
        theMetaObject = objMetaObject;
        theOrientation = iOrientation;
        theController = objController;
        theMouseListener = new SizeboxMouseListener(this);
        theMouseMotionListener = new SizeboxMouseMotionListener(this);
        addMouseListener(theMouseListener);
        addMouseMotionListener(theMouseMotionListener);
        this.theDesignCockpit = theDesignCockpit;
        this.setOpaque(true);
    }

    public void kill() {
        if (theMouseListener != null)
            theMouseListener.kill();
    }

    public void locate() {
        Component theComponent = theMetaObject.theVisualObject;
        if (theComponent == null)
            return;
        Point ptLocation = theComponent.getLocation();
        Dimension dimSize = theComponent.getSize();
        int x = 0;
        int y = 0;
        switch (theOrientation) {
            case Sizebox.NORTH:
                x = (int) ptLocation.getX() + ((int) dimSize.getWidth() - width) / 2;
                y = (int) ptLocation.getY() - height;
                break;
            case Sizebox.NORTHEAST:
                x = (int) ptLocation.getX() + (int) dimSize.getWidth();
                y = (int) ptLocation.getY() - height;
                break;
            case Sizebox.EAST:
                x = (int) ptLocation.getX() + (int) dimSize.getWidth();
                y = (int) ptLocation.getY() + ((int) dimSize.getHeight() - height) / 2;
                break;
            case Sizebox.SOUTHEAST:
                x = (int) ptLocation.getX() + (int) dimSize.getWidth();
                y = (int) ptLocation.getY() + (int) dimSize.getHeight();
                break;
            case Sizebox.SOUTH:
                x = (int) ptLocation.getX() + ((int) dimSize.getWidth() - width) / 2;
                y = (int) ptLocation.getY() + (int) dimSize.getHeight();
                break;
            case Sizebox.SOUTHWEST:
                x = (int) ptLocation.getX() - width;
                y = (int) ptLocation.getY() + (int) dimSize.getHeight();
                break;
            case Sizebox.WEST:
                x = (int) ptLocation.getX() - width;
                y = (int) ptLocation.getY() + ((int) dimSize.getHeight() - height) / 2;
                break;
            case Sizebox.NORTHWEST:
                x = (int) ptLocation.getX() - width;
                y = (int) ptLocation.getY() - height;
                break;
        }
        setLocation(x, y);
        setSize(width, height);
    }

    void dragAction(MouseEvent evt) {
        Component theComponent = theMetaObject.theVisualObject;
        if (theComponent == null)
            return;
        Point ptLocation = theComponent.getLocation();
        Dimension dimSize = theComponent.getSize();
        Point ptDragTo = evt.getPoint();
        int x = 0;
        int y = 0;
        int cx = 0;
        int cy = 0;
        switch (theOrientation) {
            case Sizebox.NORTH:
                x = (int) ptLocation.getX();
                y = (int) ptLocation.getY() - (int) ptDragFrom.getY() + (int) ptDragTo.getY();
                cx = (int) dimSize.getWidth();
                cy = (int) dimSize.getHeight() + (int) (ptDragFrom.getY() - ptDragTo.getY());
                break;
            case Sizebox.NORTHEAST:
                x = (int) ptLocation.getX() - (int) ptDragFrom.getX() + (int) ptDragTo.getX();
                y = (int) ptLocation.getY() - (int) ptDragFrom.getY() + (int) ptDragTo.getY();
                cx = (int) dimSize.getWidth() + (int) (ptDragTo.getX() - ptDragFrom.getX());
                cy = (int) dimSize.getHeight() + (int) (ptDragFrom.getY() - ptDragTo.getY());
                break;
            case Sizebox.EAST:
                x = (int) ptLocation.getX();
                y = (int) ptLocation.getY();
                cx = (int) dimSize.getWidth() + (int) (ptDragTo.getX() - ptDragFrom.getX());
                cy = (int) dimSize.getHeight();
                break;
            case Sizebox.SOUTHEAST:
                x = (int) ptLocation.getX();
                y = (int) ptLocation.getY();
                cx = (int) dimSize.getWidth() + (int) (ptDragTo.getX() - ptDragFrom.getX());
                cy = (int) dimSize.getHeight() + (int) (ptDragTo.getY() - ptDragFrom.getY());
                break;
            case Sizebox.SOUTH:
                x = (int) ptLocation.getX();
                y = (int) ptLocation.getY();
                cx = (int) dimSize.getWidth();
                cy = (int) dimSize.getHeight() + (int) (ptDragTo.getY() - ptDragFrom.getY());
                break;
            case Sizebox.SOUTHWEST:
                x = (int) ptLocation.getX() + (int) (ptDragTo.getX() - ptDragFrom.getX());
                y = (int) ptLocation.getY();
                cx = (int) dimSize.getWidth() + (int) (ptDragFrom.getX() - ptDragTo.getX());
                cy = (int) dimSize.getHeight() + (int) (ptDragTo.getY() - ptDragFrom.getY());
                break;
            case Sizebox.WEST:
                x = (int) ptLocation.getX() + (int) (ptDragTo.getX() - ptDragFrom.getX());
                y = (int) ptLocation.getY();
                cx = (int) dimSize.getWidth() + (int) (ptDragFrom.getX() - ptDragTo.getX());
                cy = (int) dimSize.getHeight();
                break;
            case Sizebox.NORTHWEST:
                x = (int) ptLocation.getX() - (int) ptDragFrom.getX() + (int) ptDragTo.getX();
                y = (int) ptLocation.getY() - (int) ptDragFrom.getY() + (int) ptDragTo.getY();
                cx = (int) dimSize.getWidth() + (int) (ptDragFrom.getX() - ptDragTo.getX());
                cy = (int) dimSize.getHeight() + (int) (ptDragFrom.getY() - ptDragTo.getY());
                break;
        }
        if (theController.theMetaObject.bResizing == false)
            beginResizing(theMetaObject);
//        int iGridX = theDesignCockpit.theViewDisplayer.iAlignmentGridWidth;
//        int iGridY = theDesignCockpit.theViewDisplayer.iAlignmentGridHeight;
//      if ((x%iGridX==0) && (cx%iGridX==0) && (y%iGridY==0) && (cy%iGridY==0))
        theController.relocate(x, y, cx, cy, true, true, true);
    }

    public void paint(Graphics g) {
        g.setColor(new Color(0, 0, 0));
        g.fillRect(0, 0, width, height);
    }

    void beginResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = true;
        theDesignCockpit.getDesignProject().theUndoRedoController.createChangeSizeEvent(theMetaObject);
    }

    void beginDragging(MetaObject theMetaObject) {
        int iSelectedObjectCount = theDesignCockpit.getDesignProject().getSelectedObjectCount();
        ArrayList theObjects = new ArrayList(iSelectedObjectCount);
        for (int i = 0; i < iSelectedObjectCount; i++) {
            theObjects.add(theDesignCockpit.getDesignProject().getSelectedObject(i));
        }
        theDesignCockpit.getDesignProject().theUndoRedoController.createChangeLocationEvent(theObjects);
        theMetaObject.bDragged = true;
    }

    // If size didn't change, remove the event
    void endResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = false;
    }

    void endDragging(MetaObject theMetaObject) {
        theMetaObject.bDragged = false;
    }

    boolean isResizingHorizontal() {
        return ( (theOrientation != Sizebox.NORTH) && (theOrientation != SOUTH) );
    }
    boolean isResizingVertical() {
        return ( (theOrientation != Sizebox.WEST) && (theOrientation != EAST) );
    }

}

