/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 9:30:38 PM
 * To change this template use Options | File Templates.
 */

public class Sizeboxes {
    MetaObject theMetaObject;
    JComponent theParentContainer = null;
    Sizebox[] theBoxes = new Sizebox[Sizebox.NORTHWEST + 1];
    SuperDesignCockpit theDesignCockpit = null;

    public Sizeboxes (MetaObject objMetaObject, int width, int height, SuperDesignCockpit theDesignCockpit) {
        theMetaObject = objMetaObject;
        this.theDesignCockpit = theDesignCockpit;
        MetaObject theParent = null;  // Where to embed the boxes.
        IDEViewDisplayer theViewDisplayer = theDesignCockpit.theViewDisplayer;
        theParentContainer = null;
        if ((theMetaObject.isPanel() == true) || (theMetaObject.isGroup()) || (theMetaObject.isScrollPane() == true) ||
            (theMetaObject.isTabbedPane() == true) || (theMetaObject.isScrollingPanel() == true)
                ||(theMetaObject.isJToolBar() == true) || (theMetaObject.isJMenuBar() == true))
            theParent = theMetaObject.getVisualContainerObject(true);  // search for parent from parent
        else if (theMetaObject.isAbalet() || theMetaObject.isFrame())
            theParentContainer = theDesignCockpit.theViewDisplayer;
        else
            theParent = theMetaObject.getVisualContainerObject(false);
        if (theParentContainer == null)
            theParentContainer = theParent.theVisualObject;
        DesignAnchoringLayoutManager theManager = null;
        if (theParentContainer.getLayout() instanceof DesignAnchoringLayoutManager)
            theManager = (DesignAnchoringLayoutManager) theParentContainer.getLayout();
        if ((theParent != null) && (theParent.isHorzSplit() || theParent.isVertSplit()))
            return;
        for (int i = Sizebox.NORTH; i <= Sizebox.NORTHWEST; i++) {
            theBoxes[i] = new Sizebox(objMetaObject, i, this, theDesignCockpit);
            theBoxes[i].width = width;
            theBoxes[i].height = height;
            if (theParentContainer.equals(theViewDisplayer))
                theViewDisplayer.add(theBoxes[i]);
            else {
                String theName = objMetaObject.getName() + "_SizeBox_" + i;
                if (theParentContainer instanceof JLayeredPane) {
                    JLayeredPane thePane = (JLayeredPane) theParentContainer;
                    thePane.add(theBoxes[i], theName, theMetaObject.iDisplayLayer);
                } else
                    theParentContainer.add(theBoxes[i], theName);
            }
            if (theManager != null)
                theManager.setAnchoring(theBoxes[i], objMetaObject, false, false, false, false);
            theBoxes[i].locate();
        }
    }

    public void kill () {
        for (int i = Sizebox.NORTH; i <= Sizebox.NORTHWEST; i++) {
            if (theBoxes[i] != null) {
                theBoxes[i].kill();
                theParentContainer.remove(theBoxes[i]);
                theBoxes[i] = null;
            }
        }
        theParentContainer.repaint();
    }

    public void relocate (int x, int y, int cx, int cy, boolean bStillDragging, boolean bResizeHorizontal, boolean bResizeVertical) {
        if (bStillDragging)
            theDesignCockpit.resizeAction(theMetaObject, x, y, cx, cy, MetaObject.RESIZE_CONTEXT_SIZEBOX_RESIZING, bResizeHorizontal, bResizeVertical);
        else {
            theMetaObject.bAnchoringOff = true; // this will force the anchor offsets to be re-calculated
            theDesignCockpit.resizeAction(theMetaObject, x, y, cx, cy, MetaObject.RESIZE_CONTEXT_SIZEBOX_RESIZED, bResizeHorizontal, bResizeVertical);
        }
        Point ptLocation = theMetaObject.getLocation();
        Dimension dimSize = theMetaObject.getSize();
        if (theMetaObject.theVisualObject != null) {
            dimSize = theMetaObject.theVisualObject.getSize();
            ptLocation = theMetaObject.theVisualObject.getLocation();
        } else if (theMetaObject.theVisualFrame != null) {
            dimSize = theMetaObject.theVisualFrame.getSize();
            ptLocation = theMetaObject.theVisualFrame.getLocation();
        }
        theMetaObject.theVisualObject.setLocation((int) ptLocation.getX(), (int) ptLocation.getY());
        theMetaObject.theVisualObject.setSize((int) dimSize.getWidth(), (int) dimSize.getHeight());
        if (theMetaObject.theLayoutManager != null) {
            if (theMetaObject.theLayoutManager instanceof DesignAnchoringLayoutManager) {
                DesignAnchoringLayoutManager theLayoutManager = (DesignAnchoringLayoutManager) theMetaObject.theLayoutManager;
                theLayoutManager.layoutContainer(theMetaObject.theVisualObject);
            } else {
                AnchoringLayoutManager theLayoutManager = (AnchoringLayoutManager) theMetaObject.theLayoutManager;
                theLayoutManager.layoutContainer(theMetaObject.theVisualObject);
            }
            MetaObject theSelectedObject = theDesignCockpit.getSelectedObject();
            if ((theSelectedObject != null) && (theMetaObject != theSelectedObject)) {
                theDesignCockpit.SelectObject(null, false);
                theDesignCockpit.SelectObject(theMetaObject, false);
            }
        }
        if (theMetaObject.isScrollPane() || theMetaObject.isTabbedPane()) {
            MetaObject theChild = theMetaObject.theFirstChild;
            while (theChild != null) {
                theChild.theVisualObject.setLocation(0, 0);
                theChild.theVisualObject.setSize(dimSize);
                theChild.setPropertyValue("Location.Top", 0, 1, theMetaObject.getPropertyValue("Location.Top", 0));
                theChild.setPropertyValue("Location.Left", 0, 0, theMetaObject.getPropertyValue("Location.Left", 0));
                theChild.setPropertyValue("Size.Width", 0, 0, theMetaObject.getPropertyValue("Size.Width", 0));
                theChild.setPropertyValue("Size.Height", 0, 1, theMetaObject.getPropertyValue("Size.Height", 0));
                theChild = theChild.theNextObject;
            }
        }
        for (int i = Sizebox.NORTH; i <= Sizebox.NORTHWEST; i++) {
            if (theBoxes[i] != null)
                theBoxes[i].locate();
        }
    }

    public void update (int x, int y, int cx, int cy) {
        MetaObject theParent = null;  // Where to embed the boxes.
        if ((theMetaObject.isPanel() == true) || (theMetaObject.isGroup()) ||
        (theMetaObject.isScrollPane() == true) || (theMetaObject.isTabbedPane() == true) || (theMetaObject.isScrollingPanel() == true) 
           ||(theMetaObject.isJToolBar() == true) || (theMetaObject.isJMenuBar() == true))
            theParent = theMetaObject.getVisualContainerObject(true);  // search for parent from parent
        else if (theMetaObject.isAbalet() || theMetaObject.isFrame())
            theParentContainer = theDesignCockpit.theViewDisplayer;
        else
            theParent = theMetaObject.getVisualContainerObject(false);
        if (theParentContainer == null)
            theParentContainer = theParent.theVisualObject;
        for (int i = Sizebox.NORTH; i <= Sizebox.NORTHWEST; i++) {
            if (theBoxes[i] != null) {
                theBoxes[i].setVisible(false);
                theBoxes[i].locate();
                theBoxes[i].setVisible(true);
                if (theParentContainer instanceof JLayeredPane) {
                    String sName = ((DesignAnchoringLayoutManager) theParent.theLayoutManager).getName(theBoxes[i]);
                    ((JLayeredPane) theParentContainer).setLayer(theBoxes[i], theMetaObject.iDisplayLayer);
                    if (sName != null) {
                        ((DesignAnchoringLayoutManager) theParent.theLayoutManager).addLayoutComponent(sName, theBoxes[i]);
                        ((DesignAnchoringLayoutManager) theParent.theLayoutManager).setAnchoring(theBoxes[i], theMetaObject,
                                theMetaObject.bLeftAnchoring, theMetaObject.bRightAnchoring,
                                theMetaObject.bTopAnchoring, theMetaObject.bBottomAnchoring);
                    }
                }
//                    ((JLayeredPane)theParentContainer).setLayer(theBoxes[i], theMetaObject.iDisplayLayer);
            }
        }
    }

    /**
     * Resizes the boxes as the user changed the preferred size
     */
    public void resizeSizeBoxes () {
        int iWidth, iHeight;
        iWidth = theDesignCockpit.thePreferences.iSizeBoxWidth;
        iHeight = theDesignCockpit.thePreferences.iSizeBoxHeight;

        for (int iBox = Sizebox.NORTH; iBox <= Sizebox.NORTHWEST; iBox++) {
            if (theBoxes[iBox] != null) {
                theBoxes[iBox].setSize(iWidth, iHeight);
            }
        }
    }

}
