/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;

import javax.swing.BorderFactory;
import javax.swing.*;
import javax.swing.table.AbstractTableModel;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Nov 11, 2004
 * Time: 11:47:27 PM
 * To change this template use File | Settings | File Templates.
 */
public class AboutDialog extends JADialog {
    private final MetadataEditor theEditor;

    public AboutDialog (MetadataEditor editor) {
        super(editor, "About Metadata Editor", true, false);
        theEditor = editor;

        JATabbedPane theAboutBoxPane = new JATabbedPane();
        theAboutBoxPane.setBorder(BorderFactory.createRaisedBevelBorder());

        ProductInformationPanel theProductInfoPanel = new ProductInformationPanel(editor);
        SystemInformationPanel theSystemInfoPanel = new SystemInformationPanel();

        theAboutBoxPane.addTab("Version Information", theProductInfoPanel);
        theAboutBoxPane.addTab("System Information", theSystemInfoPanel);

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(theAboutBoxPane, BorderLayout.CENTER);
        JAPanel theButtonPanel = new JAPanel();
        theButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

        getContentPane().add(theButtonPanel, BorderLayout.SOUTH);
        JAButton theButton = new JAButton("OK");
        theButtonPanel.add(theButton);
        theButton.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent ae) {
                AboutDialog.this.hide();
            }
        });
        setResizable(true);
        setSize(600, 320);
        setLocationRelativeTo(null); // center on screen
        show(null) ;
    }

    class ProductInformationPanel extends JAPanel {
        public ProductInformationPanel (MetadataEditor editor) {
            setLayout(new BorderLayout());
            String sHead = "<HTML><Body><CENTER>";
            String sFoot = "</Body></HTML>";

            String sToolName = "Metadata Editor";

            String sCaption = "<B>" +sToolName +"</b><BR><p>";

            String sVersion = "<B>Version:</B> "+ editor.getVersionNumber() +"<P>";
            String sRevision = "<B>Revision:</B> " +editor.getRevisionNumber() +"<P>";
            String sSubRevision = "<B>Sub Revsion:</B> " +editor.getSubRevisionNumber() +"<P>";
            String sBuild = "<B>Build:</B> " +editor.getBuildNumber() +"<P>";

            add(new JALabel(sHead +sCaption +sVersion +sRevision +sSubRevision +sBuild +sFoot, JLabel.CENTER), BorderLayout.CENTER);

        }
    }

    class SystemPropertyModel extends AbstractTableModel {
        int iRowCount = 0;
        ArrayList ColumnOneValues = new ArrayList(0);
        ArrayList ColumnTwoValues = new ArrayList(0);

        public SystemPropertyModel () {
        }

        public void addPair (String sName, String sValue) {
            ColumnOneValues.add(sName);
            ColumnTwoValues.add(sValue);
        }

        public int getRowCount () {
            return ColumnOneValues.size();
        }

        public Object getValueAt (int iRow, int iCol) {
            if (iCol == 0)
                return ColumnOneValues.get(iRow);
            else
                return ColumnTwoValues.get(iRow);
        }

        public String getColumnName (int iCol) {
            if (iCol == 0)
                return "Property";
            else
                return "Value";
        }

        public int getColumnCount () {
            return 2;
        }
    }

    class SystemInformationPanel extends JAPanel {
        public SystemInformationPanel () {
            Properties sysprops = System.getProperties();
            SystemPropertyModel thePropertyModel = new SystemPropertyModel();
            for (Enumeration e = sysprops.propertyNames(); e.hasMoreElements();) {
                String sPropName = (String) e.nextElement();
                String sPropValue = System.getProperty(sPropName);
                thePropertyModel.addPair(sPropName, sPropValue);
            }
            JATable thePropertyTable = new JATable(thePropertyModel);
            setLayout(new BorderLayout());
            add(new JAScrollPane(thePropertyTable));
        }
    }


}
