/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Jul 9, 2004
 * Time: 6:43:18 PM
 * To change this template use Options | File Templates.
 */
public class EditGroupConstantsDialog extends JDialog {
    JTextField txtName = new JTextField(40);
    JTextField txtValue = new JTextField(40);
    private ManageGroupConstantsDialog dialog;

    public EditGroupConstantsDialog (ManageGroupConstantsDialog dialog, String title, boolean bEdit) throws HeadlessException {
        super(dialog, title, true);
        this.dialog = dialog;

        initInterface();
        if (bEdit) {
            populateInterface();
        }
        dialog.marshalledConstantName = null;  // we shall be writing to these if the dialog is OK
        dialog.marshalledConstantValue = null;
        pack();
        setLocationRelativeTo(dialog);

    }

    void initInterface () {
        JLabel lblName = new JLabel("Name");
        JLabel lblValue = new JLabel("Value");

        JButton btnOK = new JButton("OK");
        JButton btnCancel = new JButton("Cancel");

        btnOK.addActionListener(new OkAction(this));
        btnCancel.addActionListener(new CancelAction(this));

        JPanel pnlButtons = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        pnlButtons.add(btnOK);
        pnlButtons.add(btnCancel);

        Container pane = getContentPane();

        pane.setLayout(new BorderLayout());
        JPanel pnlControls = new JPanel(new GridLayout(4, 1));
        pnlControls.setBorder(BorderFactory.createTitledBorder(dialog.theGroup.sClassName));
        pnlControls.add(lblName);
        pnlControls.add(txtName);
        pnlControls.add(lblValue);
        pnlControls.add(txtValue);

        pane.add(pnlControls, BorderLayout.NORTH);
        pane.add(pnlButtons, BorderLayout.SOUTH);
    }

    void populateInterface () {
        txtName.setText(dialog.marshalledConstantName);
        txtValue.setText(dialog.marshalledConstantValue);
    }

    class CancelAction implements ActionListener {
        private final EditGroupConstantsDialog theEditDialog;

        public CancelAction (EditGroupConstantsDialog editDialog) {
            theEditDialog = editDialog;
        }

        public void actionPerformed (ActionEvent e) {
            hide();
        }
    }


    class OkAction implements ActionListener {
        private final EditGroupConstantsDialog theEditDialog;

        public OkAction (EditGroupConstantsDialog editDialog) {
            theEditDialog = editDialog;
        }

        public void actionPerformed (ActionEvent e) {
            dialog.marshalledConstantName = theEditDialog.txtName.getText();
            dialog.marshalledConstantValue = theEditDialog.txtValue.getText();

            hide();

        }
    }

}
