/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Apr 13, 2004
 * Time: 4:12:17 PM
 * To change this template use Options | File Templates.
 */
public class ManageConstantCollectionsDialog extends JDialog {
    final MetadataEditor editor;
    JAList lstCollection = null;
    ArrayList bufferedActionCollection = new ArrayList();
    ManageConstantCollectionsDialog thisObject;

    public ManageConstantCollectionsDialog (MetadataEditorPageConstantCollections pageCollections, String sCaption, String sCollectionTitle) {
        super(pageCollections.editor, sCaption, true);
        lstCollection = new JAList();
        this.editor = pageCollections.editor;
        initDisplay(sCollectionTitle, lstCollection);
        displayCollections(getCollections(), (String) pageCollections.lstCollections.getSelectedValue());
        thisObject = this;
    }

    private void initDisplay (String sCaption, JComponent list) {
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel(new BorderLayout());
        pnlConstants.setBorder(BorderFactory.createTitledBorder(sCaption));
        pnlConstants.add(new JScrollPane(list), BorderLayout.CENTER);
        JAButton btnAdd = new JAButton("Add");
        JAButton btnRename = new JAButton("Rename");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener(new AddCollectionAction(this));
        btnRename.addActionListener(new RenameCollectionAction(this));
        btnDelete.addActionListener(new DeleteCollectionAction(this));
        JAPanel pnlButtons = new JAPanel(new FlowLayout(FlowLayout.LEFT, 5, 5));
        pnlButtons.add(btnAdd);
        pnlButtons.add(btnRename);
        pnlButtons.add(btnDelete);
        pnlConstants.add(pnlButtons, BorderLayout.SOUTH);
        pane.add(pnlConstants, BorderLayout.CENTER);
        JAPanel pnlDialogButtons = new JAPanel(new FlowLayout(FlowLayout.RIGHT, 5, 5));

        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener(new OkAction(this));
        btnCancel.addActionListener(new CancelAction(this));

        pnlDialogButtons.add(btnOK);
        pnlDialogButtons.add(btnCancel);
        pane.add(pnlDialogButtons, BorderLayout.SOUTH);

        setSize(400, 300);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing (WindowEvent e) {
                CancelAction cancelAction = new CancelAction((thisObject));
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    Object[] getCollections () {
        ArrayList collections = new ArrayList();
        MetaConstantGroupCollection collection = editor.theMetadataDispenser.getFirstMetaConstantGroupCollection();
        while (collection != null) {
            collections.add(collection.sClassName);
            collection = collection.theNextSibling;
        }
        return collections.toArray();
    }

    void displayCollections (Object[] collections, String selectedCollection) {
        lstCollection.setListData(collections);
        if (selectedCollection != null)
            lstCollection.setSelectedValue(selectedCollection, true);
        else if (lstCollection.getModel().getSize() > 0)
            lstCollection.setSelectedIndex(0);

    }

    class RenameCollectionAction implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public RenameCollectionAction (ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            int iSelectedIndex = dialog.lstCollection.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(dialog, "You must select a collection before you can rename it.", "No Collection Selected", JOptionPane.ERROR_MESSAGE);
                return;
            }

            String sOldName = (String) dialog.lstCollection.getSelectedValue();
            String sNewName = JOptionPane.showInputDialog("Rename Collection \"" + sOldName + "\"\n\nPlease enter new name:");
            if (sNewName != null) {
                // buffer this action until the dialog's OK button is clicked...
                addBufferedAction(sOldName, sNewName);

                // Update the list...
                int iNumNames = dialog.lstCollection.getModel().getSize();
                String[] names = new String[iNumNames];
                for (int iName = 0; iName < iNumNames; iName++) {
                    names[iName] = (String) dialog.lstCollection.getModel().getElementAt(iName);
                }
                names[iSelectedIndex] = sNewName;
                displayCollections(names, sNewName);
            }
        }

        void addBufferedAction (String sOldName, String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionRename(sOldName, sNewName);
            bufferedActionCollection.add(bufferedAction);
        }
    }

    class AddCollectionAction implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public AddCollectionAction (ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            String sNewName = JOptionPane.showInputDialog("Add New Collection:");
            if (sNewName != null) {
                // buffer this action until the dialog's OK button is clicked...
                addBufferedAction(sNewName);

                // Update the list...
                int iNumNames = dialog.lstCollection.getModel().getSize();
                String[] names = new String[iNumNames + 1];
                for (int iName = 0; iName < iNumNames; iName++) {
                    names[iName] = (String) dialog.lstCollection.getModel().getElementAt(iName);
                }
                names[iNumNames] = sNewName;
                displayCollections(names, sNewName);
            }
        }

        void addBufferedAction (String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionAdd(sNewName);
            bufferedActionCollection.add(bufferedAction);
        }
    }

    class DeleteCollectionAction implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public DeleteCollectionAction (ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            int iSelectedIndex = dialog.lstCollection.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(dialog, "You must select a collection before you can delete it.", "No Collection Selected", JOptionPane.ERROR_MESSAGE);
                return;
            }

            String sOldName = (String) dialog.lstCollection.getSelectedValue();
            Object sConfirmationText = "Are you sure you want to delete the collection  \"" + sOldName + "\" ?";
            String sConfirmationTitle = "Delete Constant-Group Collection";
            int optionType = JOptionPane.YES_NO_OPTION;
            int messageType = JOptionPane.QUESTION_MESSAGE;
            int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
            if (iChoice == JOptionPane.YES_OPTION) {
                // buffer this action until the dialog's OK button is clicked...
                addBufferedAction(sOldName);

                // Update the list...
                int iNumNames = dialog.lstCollection.getModel().getSize();
                String[] names = new String[iNumNames - 1];
                int iName = 0;
                for (int iLoop = 0; iLoop < iNumNames; iLoop++) {
                    if (iLoop != iSelectedIndex) {
                        names[iName] = (String) dialog.lstCollection.getModel().getElementAt(iLoop);
                        iName++;
                    }
                }
                //dialog.lstCollection.setListData(names);
                // try to set the selected index to the next entry, or the first if we just deleted the last...
                String sCollectionToSelect = null;
                if (iSelectedIndex != iNumNames - 1)
                    sCollectionToSelect = (String) dialog.lstCollection.getModel().getElementAt(iSelectedIndex + 1);

                displayCollections(names, sCollectionToSelect);
            }
        }

        void addBufferedAction (String sOldName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionDelete(sOldName);
            bufferedActionCollection.add(bufferedAction);
        }
    }

    class CancelAction implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public CancelAction (ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            if (dialog.bufferedActionCollection.size() > 0) {
                Object sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == JOptionPane.YES_OPTION) {
                    dialog.hide();
                }
            } else
                hide();
        }
    }


    class OkAction implements ActionListener {
        private final ManageConstantCollectionsDialog dialog;

        public OkAction (ManageConstantCollectionsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            MetadataDispenser theMetadataDispenser = dialog.editor.theMetadataDispenser;
            if (dialog.bufferedActionCollection.size() == 0)
                return; // nothing to do!

            for (int iAction = 0; iAction < dialog.bufferedActionCollection.size(); iAction++) {
                BufferedAction bufferedAction = (BufferedAction) dialog.bufferedActionCollection.get(iAction);
                //System.out.println(iAction + ": " + bufferedAction.getActionType() + " " + bufferedAction.getOldName() + " " + bufferedAction.getNewName());

                switch (bufferedAction.getActionType()) {
                    case BufferedAction.ACTION_RENAME:
                        {
                            MetaConstantGroupCollection collection = theMetadataDispenser.findConstantGroupCollection(bufferedAction.getOldName());
                            if (collection != null) {
                                collection.sClassName = bufferedAction.getNewName();
                            } else
                                System.out.println("Cannot Rename Collection " + bufferedAction.getOldName() + ", as it cannot be found");
                            break;
                        }
                    case BufferedAction.ACTION_ADD:
                        {
                            // create the new collection...
                            MetaConstantGroupCollection collection = new MetaConstantGroupCollection(bufferedAction.getNewName(), theMetadataDispenser);
                            collection.theNextSibling = null;

                            // now add it to the end of the chain..
                            MetaConstantGroupCollection theLastCollection = theMetadataDispenser.getLastMetaConstantGroupCollection();
                            if (theLastCollection == null) { // there are no collections, so create the first...
                                theMetadataDispenser.setFirstMetaConstantGroupCollection(collection);
                            } else {
                                theLastCollection.theNextSibling = collection;
                                collection.thePreviousSibling = theLastCollection;
                            }
                            theMetadataDispenser.setLastMetaConstantGroupCollection(collection);
                            break;
                        }
                    case BufferedAction.ACTION_DELETE:
                        {
                            MetaConstantGroupCollection collection = theMetadataDispenser.findConstantGroupCollection(bufferedAction.getOldName());
                            if (collection != null) {
                                MetaConstantGroupCollection theFirstCollection = theMetadataDispenser.getFirstMetaConstantGroupCollection();
                                MetaConstantGroupCollection theLastCollection = theMetadataDispenser.getLastMetaConstantGroupCollection();
                                if (collection == theFirstCollection) {
                                    theMetadataDispenser.setFirstMetaConstantGroupCollection(theFirstCollection.theNextSibling);
                                    if (theFirstCollection != theLastCollection) { // only if there is still at least one collection
                                        theMetadataDispenser.getFirstMetaConstantGroupCollection().thePreviousSibling = null;
                                    } else {
                                        theMetadataDispenser.setLastMetaConstantGroupCollection(null);
                                    }
                                    collection = null;
                                } else if (collection == theLastCollection) {
                                    theMetadataDispenser.setLastMetaConstantGroupCollection(theLastCollection.thePreviousSibling);
                                    theMetadataDispenser.getLastMetaConstantGroupCollection().theNextSibling = null;
                                    collection = null;
                                } else {
                                    collection.thePreviousSibling.theNextSibling = collection.theNextSibling;
                                    collection.theNextSibling.thePreviousSibling = collection.thePreviousSibling;
                                    collection = null;
                                }
                            } else
                                System.out.println("Cannot Delete Collection \"" + bufferedAction.getOldName() + "\", as it cannot be found");
                            break;
                        }

                }
            }

            dialog.hide();

        }
    }

}


