/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Apr 13, 2004
 * Time: 4:12:17 PM
 * To change this template use Options | File Templates.
 */
public class ManageConstantGroupsDialog extends JDialog {
    final MetadataEditor editor;
    JAList lstGroups = null;
    ArrayList bufferedActionCollection = new ArrayList();
    ManageConstantGroupsDialog thisObject;

    public ManageConstantGroupsDialog (MetadataEditorPageConstants pageConstants, String sCaption, String sGroupTitle) { //, String[] ConstantNames, String[] ConstantValues) {
        super(pageConstants.editor, sCaption, true);
        lstGroups = new JAList();
        this.editor = pageConstants.editor;
        initDisplay(sGroupTitle, lstGroups);
        displayGroups(getGroups(), (String) pageConstants.lstGroups.getSelectedValue());
        thisObject = this;
    }

    private void initDisplay (String sCaption, JComponent list) {
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlConstants = new JAPanel(new BorderLayout());
        pnlConstants.setBorder(BorderFactory.createTitledBorder(sCaption));
        pnlConstants.add(new JScrollPane(list), BorderLayout.CENTER);
        JAButton btnAdd = new JAButton("Add");
        JAButton btnRename = new JAButton("Rename");
        JAButton btnDelete = new JAButton("Delete");
        btnAdd.addActionListener(new AddGroupAction(this));
        btnRename.addActionListener(new RenameGroupAction(this));
        btnDelete.addActionListener(new DeleteGroupAction(this));
        JAPanel pnlButtons = new JAPanel(new FlowLayout(FlowLayout.LEFT, 5, 5));
        pnlButtons.add(btnAdd);
        pnlButtons.add(btnRename);
        pnlButtons.add(btnDelete);
        pnlConstants.add(pnlButtons, BorderLayout.SOUTH);
        pane.add(pnlConstants, BorderLayout.CENTER);
        JAPanel pnlDialogButtons = new JAPanel(new FlowLayout(FlowLayout.RIGHT, 5, 5));

        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener(new OkAction(this));
        btnCancel.addActionListener(new CancelAction(this));

        pnlDialogButtons.add(btnOK);
        pnlDialogButtons.add(btnCancel);
        pane.add(pnlDialogButtons, BorderLayout.SOUTH);

        setSize(400, 300);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing (WindowEvent e) {
                CancelAction cancelAction = new CancelAction((thisObject));
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    Object[] getGroups () {
        ArrayList groups = new ArrayList();
        MetaConstantGroup group = editor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            groups.add(group.sClassName);
            group = group.theNextSibling;
        }
        return groups.toArray();
    }

    void displayGroups (Object[] groups, String selectedGroup) {
        lstGroups.setListData(groups);
        if (selectedGroup != null)
            lstGroups.setSelectedValue(selectedGroup, true);
        else if (lstGroups.getModel().getSize() > 0)
            lstGroups.setSelectedIndex(0);

    }

    class RenameGroupAction implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public RenameGroupAction (ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            int iSelectedIndex = dialog.lstGroups.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(dialog, "You must select a group before you can rename it.", "No Group Selected", JOptionPane.ERROR_MESSAGE);
                return;
            }

            String sOldName = (String) dialog.lstGroups.getSelectedValue();
            String sNewName = JOptionPane.showInputDialog("Rename Group \"" + sOldName + "\"\n\nPlease enter new name:");
            if (sNewName != null) {
                // buffer this action until the dialog's OK button is clicked...
                addBufferedAction(sOldName, sNewName);

                // Update the list...
                int iNumNames = dialog.lstGroups.getModel().getSize();
                String[] names = new String[iNumNames];
                for (int iName = 0; iName < iNumNames; iName++) {
                    names[iName] = (String) dialog.lstGroups.getModel().getElementAt(iName);
                }
                names[iSelectedIndex] = sNewName;
                displayGroups(names, sNewName);
            }
        }

        void addBufferedAction (String sOldName, String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionRename(sOldName, sNewName);
            bufferedActionCollection.add(bufferedAction);
        }
    }

    class AddGroupAction implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public AddGroupAction (ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            String sNewName = JOptionPane.showInputDialog("Add New Group:");
            if (sNewName != null) {
                // buffer this action until the dialog's OK button is clicked...
                addBufferedAction(sNewName);

                // Update the list...
                int iNumNames = dialog.lstGroups.getModel().getSize();
                String[] names = new String[iNumNames + 1];
                for (int iName = 0; iName < iNumNames; iName++) {
                    names[iName] = (String) dialog.lstGroups.getModel().getElementAt(iName);
                }
                names[iNumNames] = sNewName;
                displayGroups(names, sNewName);
            }
        }

        void addBufferedAction (String sNewName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionAdd(sNewName);
            bufferedActionCollection.add(bufferedAction);
        }
    }

    class DeleteGroupAction implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public DeleteGroupAction (ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            int iSelectedIndex = dialog.lstGroups.getSelectedIndex();
            if (iSelectedIndex == -1) {
                JOptionPane.showMessageDialog(dialog, "You must select a group before you can delete it.", "No Group Selected", JOptionPane.ERROR_MESSAGE);
                return;
            }

            String sOldName = (String) dialog.lstGroups.getSelectedValue();
            Object sConfirmationText = "Are you sure you want to delete the group  \"" + sOldName + "\" ?";
            String sConfirmationTitle = "Delete Constant Group";
            int optionType = JOptionPane.YES_NO_OPTION;
            int messageType = JOptionPane.QUESTION_MESSAGE;
            int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
            if (iChoice == JOptionPane.YES_OPTION) {
                // buffer this action until the dialog's OK button is clicked...
                addBufferedAction(sOldName);

                // Update the list...
                int iNumNames = dialog.lstGroups.getModel().getSize();
                String[] names = new String[iNumNames - 1];
                int iName = 0;
                for (int iLoop = 0; iLoop < iNumNames; iLoop++) {
                    if (iLoop != iSelectedIndex) {
                        names[iName] = (String) dialog.lstGroups.getModel().getElementAt(iLoop);
                        iName++;
                    }
                }
                // try to set the selected index to the next entry, or the first if we just deleted the last...
                String sGroupToSelect = null;
                if (iSelectedIndex != iNumNames - 1)
                    sGroupToSelect = (String) dialog.lstGroups.getModel().getElementAt(iSelectedIndex + 1);

                displayGroups(names, sGroupToSelect);
            }
        }

        void addBufferedAction (String sOldName) {
            BufferedAction bufferedAction = new BufferedAction();
            bufferedAction.setActionDelete(sOldName);
            bufferedActionCollection.add(bufferedAction);
        }
    }

    class CancelAction implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public CancelAction (ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            if (dialog.bufferedActionCollection.size() > 0) {
                Object sConfirmationText = "All changes will be lost. Are you sure you want to cancel ?";
                String sConfirmationTitle = "Cancel Changes";
                int optionType = JOptionPane.YES_NO_OPTION;
                int messageType = JOptionPane.QUESTION_MESSAGE;
                int iChoice = JOptionPane.showConfirmDialog(dialog, sConfirmationText, sConfirmationTitle, optionType, messageType);
                if (iChoice == JOptionPane.YES_OPTION) {
                    dialog.hide();
                }
            } else
                hide();
        }
    }


    class OkAction implements ActionListener {
        private final ManageConstantGroupsDialog dialog;

        public OkAction (ManageConstantGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed (ActionEvent e) {
            MetadataDispenser theMetadataDispenser = dialog.editor.theMetadataDispenser;
            if (dialog.bufferedActionCollection.size() == 0)
                return; // nothing to do!

            for (int iAction = 0; iAction < dialog.bufferedActionCollection.size(); iAction++) {
                BufferedAction bufferedAction = (BufferedAction) dialog.bufferedActionCollection.get(iAction);
                //System.out.println(iAction + ": " + bufferedAction.getActionType() + " " + bufferedAction.getOldName() + " " + bufferedAction.getNewName());

                switch (bufferedAction.getActionType()) {
                    case BufferedAction.ACTION_RENAME:
                        {
                            MetaConstantGroup group = theMetadataDispenser.findConstantGroup(bufferedAction.getOldName());
                            if (group != null) {
                                group.sClassName = bufferedAction.getNewName();
                            } else
                                System.out.println("Cannot Rename Group " + bufferedAction.getOldName() + ", as it cannot be found");
                            break;
                        }
                    case BufferedAction.ACTION_ADD:
                        {
                            // create the new group...
                            MetaConstantGroup group = new MetaConstantGroup(bufferedAction.getNewName(), theMetadataDispenser);

                            // now add it to the end of the chain..
                            MetaConstantGroup theLastGroup = theMetadataDispenser.getLastMetaConstantGroup();
                            if (theLastGroup == null) { // there are no groups, so create the first...
                                theMetadataDispenser.setFirstMetaConstantGroup(group);
                            } else {
                                theLastGroup.theNextSibling = group;
                                group.thePrevSibling = theLastGroup;
                            }
                            theMetadataDispenser.setLastMetaConstantGroup(group);
                            break;
                        }
                    case BufferedAction.ACTION_DELETE:
                        {
                            MetaConstantGroup group = theMetadataDispenser.findConstantGroup(bufferedAction.getOldName());
                            if (group != null) {
                                MetaConstantGroup theFirstGroup = theMetadataDispenser.getFirstMetaConstantGroup();
                                MetaConstantGroup theLastGroup = theMetadataDispenser.getLastMetaConstantGroup();
                                if (group == theFirstGroup) {
                                    theMetadataDispenser.setFirstMetaConstantGroup(theFirstGroup.theNextSibling);
                                    if (theFirstGroup != theLastGroup) { // only if there is still at least one group
                                        theMetadataDispenser.getFirstMetaConstantGroup().thePrevSibling = null;
                                    } else {
                                        theMetadataDispenser.setLastMetaConstantGroup(null);
                                    }
                                } else if (group == theLastGroup) {
                                    theMetadataDispenser.setLastMetaConstantGroup(theLastGroup.thePrevSibling);
                                    theMetadataDispenser.getLastMetaConstantGroup().theNextSibling = null;
                                } else {
                                    group.thePrevSibling.theNextSibling = group.theNextSibling;
                                    group.theNextSibling.thePrevSibling = group.thePrevSibling;
                                }
                                group.removeGroupFromCollections();
                            } else
                                System.out.println("Cannot Delete Group \"" + bufferedAction.getOldName() + "\", as it cannot be found");
                            break;
                        }

                }
            }

            dialog.hide();

        }
    }

}


