/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAToolBar;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Mar 25, 2004
 * Time: 3:42:17 PM
 * Displays the catalog of metadat-related options
 */
public class MetadataCatalog extends JAToolBar {
    private final MetadataEditor editor;

    /**
     * Creates a new tool bar with the specified <code>orientation</code>.
     * The <code>orientation</code> must be either <code>HORIZONTAL</code>
     * or <code>VERTICAL</code>.
     *
     */
    public MetadataCatalog (MetadataEditor editor) {
        super();
        this.editor = editor;
        setOrientation(JToolBar.HORIZONTAL);
        setLocation(0, 0);
        setSize(100, 400);

        // Enable rollover mode
        setRollover(true);
        setBorderPainted(true);
        setFloatable(false);
        addButtons();


    }

    protected void addButtons () {
        JButton c1 = new JAButton(/*this.theDesignCockpit.impClassNameSetIcon*/);
        c1.setText("<html>General</html>");
        c1.setMargin(new Insets(0, 0, 0, 0));
        c1.setSize(90, 90);
        c1.setVerticalTextPosition(AbstractButton.BOTTOM);
        c1.setHorizontalTextPosition(AbstractButton.CENTER);
        //c1.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        c1.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent ae) {
                //editor.showPageGeneral();
            }
        });
        add(c1);


        // Add a toggle button; remove the label and margin before adding
        JButton c2 = new JAButton(/*this.theDesignCockpit.impMemberDataSetIcon*/);
        c2.setText("<html>Constants</html>");
        c2.setMargin(new Insets(0, 0, 0, 0));
        c2.setSize(90, 90);
        c2.setVerticalTextPosition(AbstractButton.BOTTOM);
        c2.setHorizontalTextPosition(AbstractButton.CENTER);
        c2.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent ae) {
                //editor.showPageConstants();
            }
        });
        add(c2);

        // Add a button to the toolbar; remove the label and margin before adding
        JButton c3 = new JAButton(/*this.theDesignCockpit.impMethodSetIcon*/);
        c3.setText("<html><CENTER>Constant<BR>Collections</CENTER></html>");
        c3.setMargin(new Insets(0, 0, 0, 0));
        c3.setSize(90, 90);
        c3.setVerticalTextPosition(AbstractButton.BOTTOM);
        c3.setHorizontalTextPosition(AbstractButton.CENTER);
        c3.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent ae) {
                //editor.showPageCollections();
            }
        });
        add(c3);
        // Add a button to the toolbar; remove the label and margin before adding

/*        JButton c4 = new JButton(this.theDesignCockpit.impPropertySetIcon);
        c4.setText("<html>" + "Properties" + "</html>");
        c4.setMargin(new Insets(0, 0, 0, 0));
        c4.setSize(90,90);
        c4.setVerticalTextPosition(AbstractButton.BOTTOM);
        c4.setHorizontalTextPosition(AbstractButton.CENTER);
        c4.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c4);

        // Add a button to the toolbar; remove the label and margin before adding
        JButton c5 = new JButton(this.theDesignCockpit.impCodeGenSetIcon);
        c5.setText("<html>" + "Code"+ "<br>" + "Generator"  + "</html>");
        c5.setMargin(new Insets(0, 0, 0, 0));
        c5.setSize(90,90);
        c5.setVerticalTextPosition(AbstractButton.BOTTOM);
        c5.setHorizontalTextPosition(AbstractButton.CENTER);
        c5.addActionListener(new LizardClassDetailViewer.ToolBarListener(this));
        theToolBar.add(c5);
*/
    }

}
