/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ui;

import java.awt.*;
import java.awt.AWTEventMulticaster;
import java.util.EventListener;

/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: Oct 10, 2004
 * Time: 6:35:17 PM
 * To change this template use File | Settings | File Templates.
 */
public class ButtonbarEventMulticaster extends AWTEventMulticaster
   implements ButtonbarListener
{
    protected ButtonbarEventMulticaster(EventListener a, EventListener b) {
        super(a, b);
    }
    public static ButtonbarListener add(ButtonbarListener a, ButtonbarListener b) {
        return (ButtonbarListener) addInternal(a, b);
    }
    public static ButtonbarListener remove(ButtonbarListener l,
                                        ButtonbarListener oldl) {
        return (ButtonbarListener) removeInternal(l,oldl);
    }
    public void nextSelected(ButtonbarEvent e) {
        //casting exception will never occur in this case
        //casting _is_ needed because this multicaster may
        //handle more than just one listener
        if (a != null) ((ButtonbarListener) a).nextSelected(e);

        if (b != null) ((ButtonbarListener) b).nextSelected(e);
    }
    public void backSelected(ButtonbarEvent e) {
        if (a != null) ((ButtonbarListener) a).backSelected(e);
        if (b != null) ((ButtonbarListener) b).backSelected(e);
    }
    public void cancelSelected(ButtonbarEvent e) {
        if (a != null) ((ButtonbarListener) a).cancelSelected(e);
        if (b != null) ((ButtonbarListener) b).cancelSelected(e);
    }
    public void finishSelected(ButtonbarEvent e) {
        if (a != null) ((ButtonbarListener) a).finishSelected(e);
        if (b != null) ((ButtonbarListener) b).finishSelected(e);
    }
    protected static EventListener addInternal(EventListener a,
                                               EventListener b) {
        if (a == null) return b;
        if (b == null) return a;
        return new ButtonbarEventMulticaster(a, b);
    }
    protected EventListener remove(EventListener oldl) {
        if (oldl == a) return b;
        if (oldl == b) return a;
        EventListener a2 = removeInternal(a, oldl);
        EventListener b2 = removeInternal(b, oldl);
        if (a2 == a && b2 == b) return this;
        return addInternal(a2, b2);
    }

}
