// copyright 2001-2002 by The Mind Electric

package electric.util.log;

import java.util.*;

/**
 * <tt>Logger</tt> is an abstract class that implements everything about
 * an ILogger except for a concrete implementation of event().
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public abstract class Logger implements ILogger
  {
  long mask;
  private long disabledMask;

  // ********** CONSTRUCTION ************************************************

  /**
   *
   */
  public Logger()
    {
    this( 0 );
    }

  /**
   * @param mask
   */
  public Logger( long mask )
    {
    this.mask = mask;
    }

  // ********** MASK ACCESSORS **********************************************

  /**
   * Return the mask that defines which events I should log.
   */
  public long getMask()
    {
    return mask;
    }

  /**
   * Set the mask that defines the events which I should log.
   * @param mask
   */
  public void setMask( long mask )
    {
    this.mask = mask;
    Log.recalcMasks();
    }

  /**
   * Add the specified mask to the current mask setting.
   * @param mask
   */
  public synchronized void addMask( long mask )
    {
    this.mask |= mask;
    Log.recalcMasks();
    }

  /**
   * Remove the specified mask from the current mask setting.
   * @param mask
   */
  public synchronized void removeMask( long mask )
    {
    this.mask &= ~mask;
    Log.recalcMasks();
    }

  /**
   * Start logging events of the specified category.
   * @param category The category.
   */
  public void startLogging( String category )
    {
    addMask( Log.getCode( category ) );
    }

  /**
   * Stop logging events of the specified category.
   * @param category The category.
   */
  public void stopLogging( String category )
    {
    removeMask( Log.getCode( category ) );
    }

  /**
   *
   */
  public synchronized void disable()
    {
    if( mask == 0 )
      return;

    disabledMask |= mask;
    mask = 0;
    Log.recalcMasks();
    }

  /**
   *
   */
  public synchronized void enable()
    {
    mask |= disabledMask;
    disabledMask = 0;
    Log.recalcMasks();
    }

  // ********** LOG AN EVENT ************************************************

  /**
   * If enabled, log an event of the specified category.
   * @param category The category.
   * @param event The event, which is often just a simple string.
   * @param timestamp The time of the event was logged.
   */
  public abstract void event( String category, Object event, Date timeetamp );
  }
