// copyright 2001-2002 by The Mind Electric

package electric.xml;

/**
 * <tt>Elements</tt> is an enumeration over a collection of elements.
 * To iterate through the collection in a typesafe way, use current(), first() and next().
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class Elements extends Nodes
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * Construct an Elements associated with the specified node list.
   * @param list The list of Element nodes.
   */
  public Elements( NodeList list )
    {
    super( list );
    }

  /**
   * Construct an Elements associated with the single specific element.
   * @param element The element.
   */
  public Elements( Element element )
    {
    super( element );
    }

  // ********** ITERATION ***************************************************

  /**
   * Return the current Element, or null if there is none.
   */
  public Element current()
    {
    return (Element) currentNode();
    }

  /**
   * Move to the first Element and return it, or null if there is none.
   */
  public Element first()
    {
    return (Element) firstNode();
    }

  /**
   * Return the current Element and then advance to the next one if present.
   */
  public Element next()
    {
    return (Element) nextNode();
    }
  }