// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.apache;

import java.io.*;
import java.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>VectorType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class VectorType extends Type
  {
  public VectorType()
    {
    // don't generate client-side java bindings for these serializers
    setInhibit( true );
    }

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );
    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "vector" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );
    Element element = sequence.addElement( xsdPrefix, "element" );
    element.setAttribute( "name", "item" );
    element.setAttribute( "minOccurs", "0" );
    element.setAttribute( "maxOccurs", "unbounded" );
    element.setAttribute( "type", getName( element, Object.class ) );
    }

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    for( Enumeration enum = ((Vector) object).elements(); enum.hasMoreElements(); )
      writer.writeObject( "item", enum.nextElement() );
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    Vector vector = (Vector) value.getObject();
    IReader[] readers = reader.getReaders( "item" );

    if( vector == null )
      {
      vector = new Vector( readers.length );
      value.setObject( vector );
      }

    for( int i = 0; i < readers.length; i++ )
      vector.addElement( readers[ i ].readObject() );
    }
  }