// copyright 2001-2002 by The Mind Electric

package electric.xml.io.collections.net;

import java.io.*;
import java.util.*;
import electric.xml.*;
import electric.xml.io.*;
import electric.xml.io.schema.*;
import electric.util.Value;

/**
 * <tt>VectorType</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class VectorType extends CollectionType
  {
  // ********** SCHEMA ******************************************************

  /**
   * @param schema
   * @throws SchemaException
   */
  public void writeSchema( Element schema )
    throws SchemaException
    {
    Type type = getType( OBJECT_ARRAY_CLASS );
    String xsdPrefix = Namespaces.getPrefix( schema, SchemaProperties.getDefaultSchema() , "xsd" );

    Element complexType = schema.addElement( xsdPrefix, "complexType" );
    complexType.setAttribute( "name", "Vector" );
    Element sequence = complexType.addElement( xsdPrefix, "sequence" );

    Element objects = sequence.addElement( xsdPrefix, "element" );
    objects.setAttribute( "name", "elements" );
    objects.setAttribute( "type", getName( type.getNamespace(), type.getName(), objects ) );
    }

  // ********** XML SERIALIZATION *******************************************

  /**
   * @param writer
   * @param object
   * @throws IOException
   */
  public void writeObject( IWriter writer, Object object )
    throws IOException
    {
    Vector vector = (Vector) object;
    Object[] array = new Object[ vector.size() ];
    vector.copyInto( array );
    writeArray( writer, "elements", array );
    }

  /**
   * @param reader
   * @param value
   * @throws IOException
   */
  public void readObject( IReader reader, Value value )
    throws IOException
    {
    Vector vector = (Vector) value.getObject();

    if( vector == null )
      {
      vector = new Vector();
      value.setObject( vector );
      }

    Object[] array = readArray( reader, "elements" );

    for( int i = 0; i < array.length; i++ )
      vector.addElement( array[ i ] );
    }
  }