// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import electric.xml.*;
import java.util.*;

/**
 * <tt>ElementsIterator</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class ElementsIterator implements Iterator
  {
  private Elements elements;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param elements
   */
  public ElementsIterator( Elements elements )
    {
    this.elements = elements;
    }

  // ********** ITERATOR METHODS ********************************************

  /**
   *
   */
  public boolean hasNext()
    {
    return (elements.current() != null);
    }

  /**
   * @throws NoSuchElementException
   */
  public Object next()
    throws NoSuchElementException
    {
    if( !hasNext() )
      throw new NoSuchElementException();

    return elements.next();
    }

  /**
   * @throws UnsupportedOperationException
   */
  public void remove()
    throws UnsupportedOperationException
    {
    throw new UnsupportedOperationException();
    }
  }