// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import electric.xml.*;

/**
 * <tt>AttributeNode</tt> processes XPath "@name" sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class AttributeNode extends NameNode
  {
  // ********** CONSTRUCTION ************************************************

  /**
   * @param string
   */
  public AttributeNode( String string )
    {
    setName( string.substring( 1 ) );
    }

  // ********** MATCHING ****************************************************

  /**
   * @param xpath
   * @param node
   * @param list
   * @throws XPathException
   */
  public void addNodes( TMEXPath xpath, Node node, NodeList list )
    throws XPathException
    {
    addNextNodes( xpath, ((Element) node).getAttributeObject( getNamespace( xpath, node ), name ), list );
    }
  }