// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import java.io.*;
import electric.util.*;
import electric.xml.*;

/**
 * <tt>TextPredicate</tt> processes XPath "[text()='value']" and "name[text()='value']" sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class TextPredicate extends NameNode
  {
  private String text;
  private boolean not;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param string
   * @throws XPathException
   */
  public TextPredicate( String string )
    throws XPathException
    {
    try
      {
      int openBracket = string.indexOf( '[' );

      if( openBracket > 0 )
        setName( string.substring( 0, openBracket ) );

      int equals = string.indexOf( '=' );

      if( equals == -1 )
        throw new XPathException( "missing = in " + string );

      if( string.charAt( equals - 1 ) == '!' )
        not = true;

      Lex lex = new Lex( string.substring( equals + 1 ) );
      lex.skipWhitespace();
      int ch = lex.read();

      if( ch == '\"' )
        text = lex.readToPattern( "\"", Lex.CONSUME | Lex.HTML );
      else if( ch == '\'' )
        text = lex.readToPattern( "'", Lex.CONSUME | Lex.HTML );
      else
        throw new XPathException( "missing quote at start of text value" );

      lex.readChar( ']' );
      }
    catch( IOException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  // ********** MATCHING ****************************************************

  /**
   * @param xpath
   * @param node
   * @param list
   * @throws XPathException
   */
  public void addNodes( TMEXPath xpath, Node node, NodeList list )
    throws XPathException
    {
    NodeList selected = new NodeList();

    for( Elements elements = ((Parent) node).getElements(); elements.hasMoreElements(); )
      {
      Element element = elements.next();
      String elementText = element.getString();

      if( elementText == null )
        continue;

      if( not )
        {
        if( text.equals( elementText ) )
          continue;
        }
      else
        {
        if( !text.equals( elementText ) )
          continue;
        }

      if( name == null )
        selected.append( new Selection( element ) );
      else if( element.hasName( getNamespace( xpath, element ), name ) )
        selected.append( new Selection( element ) );
      }

    addNextNodes( xpath, new Nodes( selected ), list );
    }
  }