// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import electric.xml.*;

/**
 * <tt>XPathNode</tt> is the abstract superclass of all classes that process
 * particular kinds of XPath sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

abstract public class XPathNode extends Node
  {
  // ********** NEXT NODE ***************************************************

  /**
   *
   */
  XPathNode next()
    {
    return (XPathNode) getNextSiblingNode();
    }

  // ********** ADDING NODES ************************************************

  /**
   * @param xpath
   * @param element
   * @param list
   * @throws XPathException
   */
  abstract public void addNodes( TMEXPath xpath, Node element, NodeList list )
    throws XPathException;

  /**
   * @param xpath
   * @param node
   * @param list
   * @throws XPathException
   */
  void addNextNodes( TMEXPath xpath, Node node, NodeList list )
    throws XPathException
    {
    if( node == null )
      return;

    XPathNode next = next();

    if( next == null )
      list.append( new Selection( node ) );
    else
      next.addNodes( xpath, node, list );
    }

  /**
   * @param xpath
   * @param nodes
   * @param list
   * @throws XPathException
   */
  void addNextNodes( TMEXPath xpath, Nodes nodes, NodeList list )
    throws XPathException
    {
    XPathNode next = next();

    if( next == null )
      {
      while( nodes.hasMoreElements() )
        list.append( new Selection( nodes.nextNode() ) );
      }
    else
      {
      while( nodes.hasMoreElements() )
        next.addNodes( xpath, nodes.nextNode(), list );
      }
    }
  }