/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.util.DebugException;

public class CompositeCollection
implements Collection {
    private final ArrayList innerCollections = new ArrayList();
    private volatile boolean canChange = true;

    public void addCollection(Collection collection) {
        if (!this.canChange) {
            throw new DebugException("Set of collections cannot be changed after it was accessed.");
        }
        this.innerCollections.add(collection);
    }

    public int size() {
        int size = 0;
        this.canChange = false;
        Iterator it = this.innerCollections.iterator();
        while (it.hasNext()) {
            size += ((Collection)it.next()).size();
        }
        return size;
    }

    public boolean contains(Object obj) {
        this.canChange = false;
        Iterator it = this.innerCollections.iterator();
        while (it.hasNext()) {
            if (!((Collection)it.next()).contains(obj)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        this.canChange = false;
        ArrayList innerIterators = new ArrayList();
        Iterator it = this.innerCollections.iterator();
        while (it.hasNext()) {
            innerIterators.add(((Collection)it.next()).iterator());
        }
        return new CompositeIterator(innerIterators.iterator());
    }

    public boolean isEmpty() {
        this.canChange = false;
        Iterator it = this.innerCollections.iterator();
        while (it.hasNext()) {
            if (((Collection)it.next()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] obj) {
        this.canChange = false;
        ArrayList value = new ArrayList();
        Iterator it = this.innerCollections.iterator();
        while (it.hasNext()) {
            value.addAll((Collection)it.next());
        }
        return value.toArray(obj);
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    protected class CompositeIterator
    implements Iterator {
        private final Iterator innerIterators;
        private Iterator currentIterator;

        protected CompositeIterator(Iterator innerIterators) {
            this.innerIterators = innerIterators;
            this.currentIterator = (Iterator)innerIterators.next();
            this.hasNext();
        }

        public boolean hasNext() {
            while (this.innerIterators.hasNext()) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = (Iterator)this.innerIterators.next();
            }
            return this.currentIterator.hasNext();
        }

        public Object next() {
            Object result = this.currentIterator.next();
            this.hasNext();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

