/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.check.types;

import tudresden.ocl.check.OclTypeException;
import tudresden.ocl.check.types.Any;
import tudresden.ocl.check.types.OclType;
import tudresden.ocl.check.types.Type;

public class Basic
implements Any {
    public static final Basic INTEGER = new Basic("Integer");
    public static final Basic REAL = new Basic("Real");
    public static final Basic BOOLEAN = new Basic("Boolean");
    public static final Basic STRING = new Basic("String");
    public static final Basic ENUMERATION = new Basic("Enumeration");
    public static final Basic OCLANY = new Basic("OclAny");
    protected String name;

    private Basic(String name) {
        this.name = name;
    }

    public Type navigateQualified(String name, Type[] qualifiers) {
        if (qualifiers != null && qualifiers.length > 0) {
            throw new OclTypeException("feature \"" + name + "\" of type " + this + " cannot be accessed with qualifier");
        }
        Type ret = null;
        ret = Basic.navigateAnyQualified(name, this, qualifiers);
        if (ret == null) {
            if (this == REAL) {
                ret = this.navigateReal(name);
            } else if (this == INTEGER) {
                ret = this.navigateInteger(name);
                if (ret == null) {
                    ret = this.navigateReal(name);
                }
            } else if (this == STRING) {
                ret = this.navigateString(name);
            }
        }
        if (ret == null) {
            throw new OclTypeException("nonexistent feature \"" + name + "\" of type " + this + " accessed");
        }
        return ret;
    }

    public Type navigateParameterized(String name, Type[] params) {
        Type ret = null;
        ret = Basic.navigateAnyParameterized(name, params);
        if (ret == null) {
            if (this == REAL) {
                ret = this.navigateReal(name, params);
            } else if (this == INTEGER) {
                ret = this.navigateInteger(name, params);
                if (ret == null) {
                    ret = this.navigateReal(name, params);
                }
            } else if (this == STRING) {
                ret = this.navigateString(name, params);
            }
        }
        if (ret == null) {
            throw new OclTypeException("nonexistent feature \"" + name + "\"(...) of type " + this + " accessed");
        }
        return ret;
    }

    public boolean conformsTo(Type t) {
        if (this == INTEGER && t == REAL) {
            return true;
        }
        return t == this;
    }

    public boolean hasState(String stateName) {
        return false;
    }

    public String toString() {
        return this.name;
    }

    protected Type navigateReal(String name) {
        if (name.equals("abs")) {
            return REAL;
        }
        if (name.equals("floor")) {
            return INTEGER;
        }
        if (name.equals("round")) {
            return INTEGER;
        }
        return null;
    }

    protected Type navigateReal(String name, Type[] params) {
        if (name.equals("max") && params.length == 1 && params[0] == REAL) {
            return REAL;
        }
        if (name.equals("min") && params.length == 1 && params[0] == REAL) {
            return REAL;
        }
        return null;
    }

    protected Type navigateInteger(String name) {
        if (name.equals("abs")) {
            return INTEGER;
        }
        return null;
    }

    protected Type navigateInteger(String name, Type[] params) {
        if (name.equals("div") && params.length == 1 && params[0] == INTEGER) {
            return INTEGER;
        }
        if (name.equals("mod") && params.length == 1 && params[0] == INTEGER) {
            return INTEGER;
        }
        if (name.equals("max") && params.length == 1 && params[0] == INTEGER) {
            return INTEGER;
        }
        if (name.equals("min") && params.length == 1 && params[0] == INTEGER) {
            return INTEGER;
        }
        return null;
    }

    protected Type navigateString(String name) {
        if (name.equals("size")) {
            return INTEGER;
        }
        if (name.equals("toUpper")) {
            return STRING;
        }
        if (name.equals("toLower")) {
            return STRING;
        }
        return null;
    }

    protected Type navigateString(String name, Type[] params) {
        if (name.equals("concat") && params.length == 1 && params[0] == STRING) {
            return STRING;
        }
        if (name.equals("substring") && params.length == 2 && params[0] == INTEGER && params[1] == INTEGER) {
            return STRING;
        }
        return null;
    }

    public static Type navigateAnyQualified(String name, Any any, Type[] qualifiers) {
        if (name.equals("oclIsNew") && qualifiers == null) {
            return BOOLEAN;
        }
        return null;
    }

    public static Type navigateAnyParameterized(String name, Type[] params) {
        if (params.length != 1) {
            return null;
        }
        if (name.equals("oclIsKindOf") && params[0] instanceof OclType) {
            return BOOLEAN;
        }
        if (name.equals("oclIsTypeOf") && params[0] instanceof OclType) {
            return BOOLEAN;
        }
        if (name.equals("oclAsType") && params[0] instanceof OclType) {
            OclType ot = (OclType)params[0];
            return ot.getType();
        }
        if (name.equals("oclInState") && params[0] == STRING) {
            return BOOLEAN;
        }
        return null;
    }

    public static String signatureString(String name, Type[] params) {
        return Basic.stringOf(name, params, '(', ')');
    }

    public static String qualifierString(String name, Type[] qualifiers) {
        if (qualifiers == null) {
            return name;
        }
        return Basic.stringOf(name, qualifiers, '[', ']');
    }

    public static String stringOf(String name, Type[] params, char openBracket, char closeBracket) {
        StringBuffer b = new StringBuffer(name);
        b.append(openBracket);
        int i = 0;
        while (i < params.length) {
            b.append(Basic.typeString(params[i]));
            if (i < params.length - 1) {
                b.append(',');
            }
            ++i;
        }
        b.append(closeBracket);
        return new String(b);
    }

    public static String typeString(Type t) {
        return t instanceof Basic ? t.toString().toLowerCase() : t.toString();
    }
}

