/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.check.types;

import tudresden.ocl.check.OclTypeException;
import tudresden.ocl.check.types.Any;
import tudresden.ocl.check.types.Basic;
import tudresden.ocl.check.types.Type;

public class Collection
implements Type {
    protected int collectionKind;
    protected Any elementType;
    public static final int COLLECTION = 23;
    public static final int SET = 47;
    public static final int BAG = 97;
    public static final int SEQUENCE = 690;

    public Collection(int collectionKind, Type elementType) throws OclTypeException {
        if (elementType != null && !(elementType instanceof Any)) {
            throw new OclTypeException("can not create collection of collections");
        }
        this.collectionKind = collectionKind;
        this.elementType = (Any)elementType;
    }

    public Any getElementType() {
        return this.elementType;
    }

    public int getCollectionKind() {
        return this.collectionKind;
    }

    public Type navigateQualified(String name, Type[] qualifiers) {
        Type ret;
        if (qualifiers != null && qualifiers.length > 0) {
            throw new OclTypeException("feature \"" + name + "\" of type " + this + " cannot be accessed with qualifier");
        }
        switch (this.collectionKind) {
            case 23: {
                ret = null;
                break;
            }
            case 47: {
                ret = this.navigateSet(name);
                break;
            }
            case 97: {
                ret = this.navigateBag(name);
                break;
            }
            case 690: {
                ret = this.navigateSequence(name);
                break;
            }
            default: {
                throw new RuntimeException("illegal collection kind");
            }
        }
        if (ret == null) {
            ret = this.navigateCollection(name);
        }
        if (ret == null) {
            throw new OclTypeException("nonexistent feature \"" + name + "\" of type " + this + " accessed");
        }
        return ret;
    }

    public Type navigateParameterized(String name, Type[] params) {
        Type ret;
        switch (this.collectionKind) {
            case 23: {
                ret = null;
                break;
            }
            case 47: {
                ret = this.navigateSet(name, params);
                break;
            }
            case 97: {
                ret = this.navigateBag(name, params);
                break;
            }
            case 690: {
                ret = this.navigateSequence(name, params);
                break;
            }
            default: {
                throw new RuntimeException("illegal collection kind");
            }
        }
        if (ret == null) {
            ret = this.navigateCollection(name, params);
        }
        if (ret == null) {
            throw new OclTypeException("nonexistent feature \"" + Basic.signatureString(name, params) + "\" of type " + this + " accessed");
        }
        return ret;
    }

    public boolean hasState(String stateName) {
        return false;
    }

    public boolean conformsTo(Type t) {
        if (t instanceof Collection) {
            Collection otherColl = (Collection)t;
            Any otherElement = otherColl.getElementType();
            return this.conformsKind(otherColl.getCollectionKind()) && this.conformsElement(otherElement);
        }
        return false;
    }

    protected boolean conformsKind(int otherKind) {
        if (otherKind == 23) {
            return true;
        }
        return this.collectionKind == otherKind;
    }

    public boolean equals(Object o) {
        if (o instanceof Collection) {
            boolean result;
            Collection c = (Collection)o;
            boolean bl = result = this.collectionKind == c.collectionKind;
            result = this.elementType == null || c.elementType == null ? result && c.elementType == null && this.elementType == null : result && this.elementType.equals(c.elementType);
            return result;
        }
        return false;
    }

    protected boolean conformsElement(Any otherElementType) {
        if (otherElementType == null) {
            return true;
        }
        if (this.elementType == null) {
            return false;
        }
        return this.elementType.conformsTo(otherElementType);
    }

    public String toString() {
        String name;
        switch (this.collectionKind) {
            case 23: {
                name = "Collection";
                break;
            }
            case 47: {
                name = "Set";
                break;
            }
            case 97: {
                name = "Bag";
                break;
            }
            case 690: {
                name = "Sequence";
                break;
            }
            default: {
                name = "ERRORCOLL";
            }
        }
        if (this.elementType == null) {
            return name;
        }
        return name + "(" + this.elementType.toString() + ")";
    }

    protected Type navigateCollection(String name) {
        if (name.equals("size")) {
            return Basic.INTEGER;
        }
        if (name.equals("isEmpty")) {
            return Basic.BOOLEAN;
        }
        if (name.equals("notEmpty")) {
            return Basic.BOOLEAN;
        }
        if (name.equals("sum")) {
            return this.getElementType();
        }
        return null;
    }

    protected Type navigateCollection(String name, Type[] params) {
        if (name.equals("includes") && params.length == 1) {
            return Basic.BOOLEAN;
        }
        if (name.equals("excludes") && params.length == 1) {
            return Basic.BOOLEAN;
        }
        if (name.equals("count") && params.length == 1) {
            return Basic.INTEGER;
        }
        if (name.equals("includesAll") && params.length == 1 && params[0] instanceof Collection) {
            return Basic.BOOLEAN;
        }
        if (name.equals("excludesAll") && params.length == 1 && params[0] instanceof Collection) {
            return Basic.BOOLEAN;
        }
        if (name.equals("exists") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return Basic.BOOLEAN;
        }
        if (name.equals("forAll") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return Basic.BOOLEAN;
        }
        if (name.equals("isUnique") && params.length == 1) {
            return Basic.BOOLEAN;
        }
        if (name.equals("sortedBy") && params.length == 1) {
            return new Collection(690, this.getElementType());
        }
        return null;
    }

    protected Type navigateSet(String name) {
        if (name.equals("asBag")) {
            return new Collection(97, this.getElementType());
        }
        if (name.equals("asSequence")) {
            return new Collection(690, this.getElementType());
        }
        return null;
    }

    protected Type navigateSet(String name, Type[] params) {
        if (name.equals("union") && params.length == 1 && params[0] instanceof Collection) {
            Collection c = (Collection)params[0];
            if (c.getCollectionKind() == 47 || c.getCollectionKind() == 97) {
                Type elementType = this.getCommonType(c.getElementType(), this.getElementType());
                return new Collection(c.getCollectionKind(), elementType);
            }
            return null;
        }
        if (name.equals("intersection") && params.length == 1 && params[0] instanceof Collection) {
            Collection c = (Collection)params[0];
            if (c.getCollectionKind() == 47 || c.getCollectionKind() == 97) {
                Type elementType = this.getCommonType(c.getElementType(), this.getElementType());
                return new Collection(47, elementType);
            }
            return null;
        }
        if (name.equals("including") && params.length == 1) {
            Type elementType = this.getCommonType(this.getElementType(), params[0]);
            return new Collection(47, elementType);
        }
        if (name.equals("excluding") && params.length == 1) {
            return new Collection(47, this.getElementType());
        }
        if (name.equals("symmetricDifference") && params.length == 1 && params[0] instanceof Collection) {
            Collection c = (Collection)params[0];
            if (c.getCollectionKind() == 47) {
                Type elementType = this.getCommonType(c.getElementType(), this.getElementType());
                return new Collection(47, elementType);
            }
            return null;
        }
        if (name.equals("select") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return new Collection(47, this.getElementType());
        }
        if (name.equals("reject") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return new Collection(47, this.getElementType());
        }
        if (name.equals("collect") && params.length == 1) {
            Type paramType = params[0];
            if (paramType instanceof Collection) {
                paramType = ((Collection)paramType).getElementType();
            }
            return new Collection(97, paramType);
        }
        if (name.equals("count") && params.length == 1) {
            return Basic.INTEGER;
        }
        return null;
    }

    protected Type navigateBag(String name) {
        if (name.equals("asSet")) {
            return new Collection(47, this.getElementType());
        }
        if (name.equals("asSequence")) {
            return new Collection(690, this.getElementType());
        }
        return null;
    }

    protected Type navigateBag(String name, Type[] params) {
        if (name.equals("union") && params.length == 1 && params[0] instanceof Collection) {
            Collection c = (Collection)params[0];
            if (c.getCollectionKind() == 47 || c.getCollectionKind() == 97) {
                Type elementType = this.getCommonType(c.getElementType(), this.getElementType());
                return new Collection(97, elementType);
            }
            return null;
        }
        if (name.equals("intersection") && params.length == 1 && params[0] instanceof Collection) {
            Collection c = (Collection)params[0];
            if (c.getCollectionKind() == 47 || c.getCollectionKind() == 97) {
                Type elementType = this.getCommonType(c.getElementType(), this.getElementType());
                return new Collection(c.getCollectionKind(), elementType);
            }
            return null;
        }
        if (name.equals("including") && params.length == 1) {
            Type elementType = this.getCommonType(this.getElementType(), params[0]);
            return new Collection(97, elementType);
        }
        if (name.equals("excluding") && params.length == 1) {
            return new Collection(97, this.getElementType());
        }
        if (name.equals("select") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return new Collection(97, this.getElementType());
        }
        if (name.equals("reject") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return new Collection(97, this.getElementType());
        }
        if (name.equals("collect") && params.length == 1) {
            Type paramType = params[0];
            if (paramType instanceof Collection) {
                paramType = ((Collection)paramType).getElementType();
            }
            return new Collection(97, paramType);
        }
        if (name.equals("count") && params.length == 1) {
            return Basic.INTEGER;
        }
        return null;
    }

    protected Type navigateSequence(String name) {
        if (name.equals("first")) {
            if (this.getElementType() == null) {
                throw new OclTypeException("element type of sequence not known (is necessary for \"first\" property)");
            }
            return this.getElementType();
        }
        if (name.equals("last")) {
            if (this.getElementType() == null) {
                throw new OclTypeException("element type of sequence not known (is necessary for \"last\" property)");
            }
            return this.getElementType();
        }
        if (name.equals("asBag")) {
            return new Collection(97, this.getElementType());
        }
        if (name.equals("asSet")) {
            return new Collection(47, this.getElementType());
        }
        return null;
    }

    protected Type navigateSequence(String name, Type[] params) {
        if (name.equals("count") && params.length == 1) {
            return Basic.INTEGER;
        }
        if (name.equals("union") && params.length == 1 && params[0].conformsTo(new Collection(690, null))) {
            Collection c = (Collection)params[0];
            Type paramType = this.getCommonType(c.getElementType(), this.getElementType());
            return new Collection(690, paramType);
        }
        if (name.equals("append") && params.length == 1) {
            Type paramType = this.getCommonType(params[0], this.getElementType());
            return new Collection(690, paramType);
        }
        if (name.equals("prepend") && params.length == 1) {
            Type paramType = this.getCommonType(params[0], this.getElementType());
            return new Collection(690, paramType);
        }
        if (name.equals("subSequence") && params.length == 2 && params[0] == Basic.INTEGER && params[1] == Basic.INTEGER) {
            return new Collection(690, this.getElementType());
        }
        if (name.equals("at") && params.length == 1 && params[0] == Basic.INTEGER) {
            return this.getElementType();
        }
        if (name.equals("including") && params.length == 1) {
            return this.navigateSequence("append", params);
        }
        if (name.equals("excluding") && params.length == 1) {
            return new Collection(690, this.getElementType());
        }
        if (name.equals("select") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return new Collection(690, this.getElementType());
        }
        if (name.equals("reject") && params.length == 1 && params[0] == Basic.BOOLEAN) {
            return new Collection(690, this.getElementType());
        }
        if (name.equals("collect") && params.length == 1) {
            Type paramType = params[0];
            if (paramType instanceof Collection) {
                paramType = ((Collection)paramType).getElementType();
            }
            return new Collection(690, paramType);
        }
        if (name.equals("asBag") && params.length == 0) {
            return new Collection(97, this.getElementType());
        }
        if (name.equals("asSet") && params.length == 0) {
            return new Collection(47, this.getElementType());
        }
        return null;
    }

    protected Type getCommonType(Type t1, Type t2) {
        Type ret = t1 == null ? t2 : (t2 == null ? t1 : (t1.conformsTo(t2) ? t2 : t1));
        return ret;
    }
}

