/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.codegen;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import tudresden.ocl.OclTree;
import tudresden.ocl.codegen.CodeFragment;
import tudresden.ocl.codegen.CodeGenerator;
import tudresden.ocl.codegen.NodeNameMap;
import tudresden.ocl.codegen.ProceduralCodeFragment;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AClassifierContext;
import tudresden.ocl.parser.node.AConstraintBody;
import tudresden.ocl.parser.node.AFormalParameter;
import tudresden.ocl.parser.node.AFormalParameterList;
import tudresden.ocl.parser.node.AFormalParameterListTail;
import tudresden.ocl.parser.node.AInvStereotype;
import tudresden.ocl.parser.node.AOperationContext;
import tudresden.ocl.parser.node.APostStereotype;
import tudresden.ocl.parser.node.APreStereotype;
import tudresden.ocl.parser.node.Node;

public abstract class ProceduralCodeGenerator
extends DepthFirstAdapter
implements CodeGenerator {
    protected ArrayList fragments;
    protected LinkedList fragmentStack;
    protected ProceduralCodeFragment topOfStack;
    private NodeNameMap nnm;
    protected OclTree tree;
    protected StringBuffer code;
    protected StringBuffer preCode;
    boolean writeToPreCode = true;
    boolean writeToStandardCode = true;
    boolean preCodeIsValid = false;
    ArrayList preVariables = new ArrayList();
    HashMap preVarTypes = new HashMap();
    int indent = 0;
    int initialIndent = 0;
    boolean newLine = true;
    String constrainedType;
    String constrainedOperation;
    String[][] parameters;
    int constraintKind;

    public ProceduralCodeGenerator() {
        this.fragments = new ArrayList();
        this.fragmentStack = new LinkedList();
        this.nnm = new NodeNameMap();
    }

    protected void beginNewFragment(String name, String type, String operation, int kind) {
        ProceduralCodeFragment pcf = new ProceduralCodeFragment(name, type, operation, kind, null);
        this.code = new StringBuffer();
        this.preCode = new StringBuffer();
        this.preCodeIsValid = false;
        this.fragments.add(pcf);
        this.fragmentStack.addFirst(pcf);
        this.topOfStack = pcf;
    }

    protected void endFragment(String resultVariable) {
        this.topOfStack.setResultVariable(resultVariable);
        if (this.preCodeIsValid) {
            StringBuffer prepend = new StringBuffer();
            StringBuffer transCode = new StringBuffer();
            Iterator iter = ((AbstractList)this.preVariables).iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.preVarTypes.get(key);
                transCode.append(this.getTransferCode(key, val));
            }
            this.code.insert(0, (Object)prepend);
            ProceduralCodeFragment prep = new ProceduralCodeFragment(this.topOfStack.getName() + "Preparation", this.topOfStack.getType(), this.topOfStack.getOperation(), 2346, this.topOfStack.getResultVariable());
            prep.setCode(this.preCode.toString());
            this.fragments.add(prep);
            ProceduralCodeFragment transfer = new ProceduralCodeFragment(this.topOfStack.getName() + "Transfer", this.topOfStack.getType(), this.topOfStack.getOperation(), 8908, null);
            transfer.setCode(transCode.toString());
            this.fragments.add(transfer);
        }
        this.topOfStack.setCode(this.code.toString());
        this.fragmentStack.removeFirst();
        this.topOfStack = this.fragmentStack.isEmpty() ? null : (ProceduralCodeFragment)this.fragmentStack.getFirst();
    }

    protected String getVariable(Node n) {
        if (this.nnm.containsKey(n)) {
            return this.nnm.get(n);
        }
        String name = this.tree.getNameCreator().getUniqueName("Node");
        this.nnm.put(n, name);
        return name;
    }

    protected void setVariable(Node n, String var) {
        if (this.nnm.containsKey(n)) {
            throw new RuntimeException("tried to assign second variable to node \"" + n + "\"; old variable: " + this.nnm.get(n) + ", new variable:" + var);
        }
        this.nnm.put(n, var);
    }

    protected void reachThrough(Node from, Node to) {
        String varName = this.nnm.get(to);
        this.nnm.put(from, varName);
    }

    protected void appendCode(String s) {
        if (this.newLine) {
            int i = 0;
            while (i < this.indent) {
                if (this.writeToStandardCode) {
                    this.code.append(" ");
                }
                if (this.writeToPreCode) {
                    this.preCode.append(" ");
                }
                ++i;
            }
        }
        if (this.writeToStandardCode) {
            this.code.append(s);
        }
        if (this.writeToPreCode) {
            this.preCode.append(s);
        }
        this.newLine = s.endsWith("\n");
    }

    public void setInitialIndent(int initialIndent) {
        if (this.initialIndent != this.indent || initialIndent < 0) {
            throw new RuntimeException();
        }
        this.initialIndent = initialIndent;
        this.indent = initialIndent;
    }

    protected void increaseIndent(int i) {
        this.indent += i;
    }

    protected void decreaseIndent(int i) {
        this.indent -= i;
        if (this.indent < this.initialIndent) {
            throw new RuntimeException();
        }
    }

    public void inAClassifierContext(AClassifierContext cc) {
        this.constrainedType = cc.getPathTypeName().toString().trim();
        this.parameters = null;
    }

    public void inAOperationContext(AOperationContext oc) {
        this.constrainedType = oc.getPathTypeName().toString().trim();
        this.constrainedOperation = oc.getName().toString().trim() + "(" + (oc.getFormalParameterList() == null ? "" : oc.getFormalParameterList().toString().trim()) + ")";
        if (oc.getFormalParameterList() == null) {
            this.parameters = new String[0][0];
        } else {
            AFormalParameterList fpl = (AFormalParameterList)oc.getFormalParameterList();
            ArrayList parameterNames = new ArrayList();
            ArrayList parameterTypes = new ArrayList();
            this.addParameter(parameterNames, parameterTypes, (AFormalParameter)fpl.getFormalParameter());
            Iterator paramIter = fpl.getFormalParameterListTail().iterator();
            while (paramIter.hasNext()) {
                AFormalParameter fp = (AFormalParameter)((AFormalParameterListTail)paramIter.next()).getFormalParameter();
                this.addParameter(parameterNames, parameterTypes, fp);
            }
            this.parameters = new String[parameterNames.size()][2];
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i][0] = (String)parameterNames.get(i);
                this.parameters[i][1] = (String)parameterTypes.get(i);
                ++i;
            }
        }
    }

    private void addParameter(ArrayList parameterNames, ArrayList parameterTypes, AFormalParameter fp) {
        parameterNames.add(fp.getName().toString().trim());
        parameterTypes.add(fp.getPathTypeName().toString().trim());
    }

    public final void caseAConstraintBody(AConstraintBody cb) {
        cb.getStereotype().apply(this);
        this.nnm.clear();
        String constraintName = cb.getName().toString().trim();
        this.beginNewFragment(constraintName, this.constrainedType, this.constrainedOperation, this.constraintKind);
        super.caseAConstraintBody(cb);
        this.endFragment(this.getVariable(cb.getExpression()));
    }

    public void inAInvStereotype(AInvStereotype is) {
        this.constraintKind = 177;
    }

    public void inAPreStereotype(APreStereotype is) {
        this.constraintKind = 7;
    }

    public void inAPostStereotype(APostStereotype is) {
        this.constraintKind = 21;
    }

    protected abstract String getTransferCode(String var1, String var2);

    protected abstract void requireTreeInvariants();

    public void assurePreCode() {
        this.preCodeIsValid = true;
    }

    public void writeToPreCodeOnly() {
        this.writeToPreCode = true;
        this.writeToStandardCode = false;
    }

    public void writeToStandardCodeOnly() {
        this.writeToPreCode = false;
        this.writeToStandardCode = true;
    }

    public void writeToBothCodes() {
        this.writeToPreCode = true;
        this.writeToStandardCode = true;
    }

    public void addPreVariable(String var, String type) {
        this.preVariables.add(var);
        this.preVarTypes.put(var, type);
    }

    public CodeFragment[] getCode(OclTree tree) {
        this.fragments.clear();
        this.tree = tree;
        this.requireTreeInvariants();
        tree.apply(this);
        return this.fragments.toArray(new CodeFragment[this.fragments.size()]);
    }
}

