/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import tudresden.ocl.lib.OclAddable;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclMultiplyable;
import tudresden.ocl.lib.OclReal;
import tudresden.ocl.lib.OclSubtractable;
import tudresden.ocl.lib.OclType;

public class OclInteger
extends OclReal {
    private long lValue;

    public OclInteger(int i) {
        this((long)i);
    }

    public OclInteger(long l) {
        super(0.0f);
        this.lValue = l;
    }

    public OclInteger(int dummy, String reason) {
        super(dummy, reason);
        this.lValue = Long.MIN_VALUE;
    }

    public OclAddable add(OclAddable a) {
        OclInteger i = this.toOclInteger(a, "OclInteger add()");
        return this.add(i);
    }

    public OclInteger add(OclInteger i) {
        if (this.isUndefined()) {
            return this;
        }
        if (i.isUndefined()) {
            return i;
        }
        return new OclInteger(this.getLong() + i.getLong());
    }

    public OclReal add(OclReal i) {
        return super.add(i);
    }

    public OclSubtractable subtract(OclSubtractable s) {
        return this.subtract(this.toOclInteger(s, "OclInteger subtract()"));
    }

    public OclInteger subtract(OclInteger oi) {
        if (this.isUndefined()) {
            return this;
        }
        if (oi.isUndefined()) {
            return oi;
        }
        return new OclInteger(this.getLong() - oi.getLong());
    }

    public OclReal negative() {
        if (this.isUndefined()) {
            return this;
        }
        return new OclInteger(-this.getLong());
    }

    public OclMultiplyable multiply(OclMultiplyable m) {
        return this.multiply(this.toOclInteger(m, "OclInteger multiply()"));
    }

    public OclInteger multiply(OclInteger oi) {
        if (this.isUndefined()) {
            return this;
        }
        if (oi.isUndefined()) {
            return oi;
        }
        return new OclInteger(this.getLong() * oi.getLong());
    }

    public OclReal multiply(OclReal oi) {
        return super.multiply(oi);
    }

    public OclMultiplyable divide(OclMultiplyable m) {
        return this.divide(this.toOclInteger(m, "OclInteger multiply()"));
    }

    public OclReal divide(OclInteger oi) {
        if (oi.lValue == 0L) {
            return new OclInteger(0, "division by zero");
        }
        if (this.isUndefined()) {
            return this;
        }
        if (oi.isUndefined()) {
            return oi;
        }
        return new OclReal(this.getDouble() / oi.getDouble());
    }

    public OclInteger mod(OclInteger i) {
        if (this.isUndefined()) {
            return this;
        }
        if (i.isUndefined()) {
            return i;
        }
        return new OclInteger(this.lValue % i.lValue);
    }

    public OclInteger max(OclInteger i) {
        if (this.isUndefined()) {
            return this;
        }
        if (i.isUndefined()) {
            return i;
        }
        return new OclInteger(Math.max(this.lValue, i.lValue));
    }

    public OclInteger min(OclInteger i) {
        if (this.isUndefined()) {
            return this;
        }
        if (i.isUndefined()) {
            return i;
        }
        return new OclInteger(Math.min(this.lValue, i.lValue));
    }

    public OclInteger div(OclInteger i) {
        if (i.lValue == 0L) {
            return new OclInteger(0, "division by zero");
        }
        if (this.isUndefined()) {
            return this;
        }
        if (i.isUndefined()) {
            return i;
        }
        return new OclInteger(this.lValue / i.lValue);
    }

    public OclReal abs() {
        if (this.isUndefined()) {
            return this;
        }
        return new OclInteger(Math.abs(this.lValue));
    }

    public int getInt() {
        if (this.isUndefined()) {
            throw new OclException("tried to evaluate undefined OclInteger: " + this.getUndefinedReason());
        }
        return (int)this.lValue;
    }

    public long getLong() {
        if (this.isUndefined()) {
            throw new OclException("tried to evaluate undefined OclInteger: " + this.getUndefinedReason());
        }
        return this.lValue;
    }

    public double getDouble() {
        if (this.isUndefined()) {
            throw new OclException("tried to evaluate undefined OclInteger: " + this.getUndefinedReason());
        }
        return this.lValue;
    }

    /*
     * WARNING - void declaration
     */
    private OclInteger toOclInteger(Object o, String methodname) {
        try {
            void cce;
            OclInteger ret = (OclInteger)o;
            return cce;
        }
        catch (ClassCastException cce) {
            return new OclInteger(0, methodname + " called with non-OclInteger parameter");
        }
    }

    public String toString() {
        return "OclInteger<" + this.lValue + ">";
    }

    public boolean equals(Object o) {
        try {
            return this.isEqualTo(o).isTrue();
        }
        catch (OclException e) {
            return false;
        }
    }

    public int hashCode() {
        return (int)this.lValue;
    }

    public OclBoolean oclIsKindOf(OclType type) {
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (type.isUndefined()) {
            return new OclBoolean(0, type.getUndefinedReason());
        }
        if (this.oclIsTypeOf(type).isTrue()) {
            return OclBoolean.TRUE;
        }
        return super.oclIsKindOf(type);
    }

    public OclType oclType() {
        if (this.isUndefined()) {
            return new OclType(0, this.getUndefinedReason());
        }
        return OclType.typeInteger;
    }
}

