/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tudresden.ocl.lib.OclBag;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclBooleanEvaluatable;
import tudresden.ocl.lib.OclCollection;
import tudresden.ocl.lib.OclIterator;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclRootEvaluatable;
import tudresden.ocl.lib.OclSubtractable;
import tudresden.ocl.lib.OclUnsortedCollection;

public class OclSet
extends OclUnsortedCollection
implements OclSubtractable {
    public OclSet(Set set) {
        super(set);
    }

    protected OclSet(List l) {
        super(l);
    }

    public OclSet(int dummy, String reason) {
        super(dummy, reason);
    }

    public static OclSet getEmptyOclSet() {
        return new OclSet(new HashSet());
    }

    public OclBoolean isEqualTo(Object o) {
        if (!(o instanceof OclSet)) {
            System.out.println("OclSet isEqualTo() is called with a non-OclSet parameter");
            return OclBoolean.FALSE;
        }
        OclSet other = (OclSet)o;
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (other.isUndefined()) {
            return new OclBoolean(0, other.getUndefinedReason());
        }
        if (this.collection.containsAll(other.collection) && other.collection.containsAll(this.collection)) {
            return OclBoolean.TRUE;
        }
        return OclBoolean.FALSE;
    }

    public OclCollection select(OclIterator iter, OclBooleanEvaluatable eval) {
        if (this.isUndefined()) {
            return this;
        }
        List list = this.selectToList(iter, eval);
        if (list == null) {
            return new OclSet(0, "error in selectToList");
        }
        return new OclSet(list);
    }

    public OclCollection collect(OclIterator iter, OclRootEvaluatable eval) {
        if (this.isUndefined()) {
            return this;
        }
        List list = this.collectToList(iter, eval);
        if (list == null) {
            return new OclSet(0, "error in collectToList");
        }
        return new OclBag(list);
    }

    public OclCollection union(OclCollection col) {
        if (this.isUndefined()) {
            return this;
        }
        if (col.isUndefined()) {
            return col;
        }
        if (col instanceof OclSet) {
            return this.union((OclSet)col);
        }
        if (col instanceof OclBag) {
            return this.union((OclBag)col);
        }
        return new OclSet(0, "tried to create union of OclSet and OclSequence");
    }

    public OclSet union(OclSet set) {
        if (this.isUndefined()) {
            return this;
        }
        if (set.isUndefined()) {
            return set;
        }
        HashSet hs = new HashSet(this.collection);
        hs.addAll(set.collection);
        return new OclSet(hs);
    }

    public OclBag union(OclBag bag) {
        if (this.isUndefined()) {
            return new OclBag(0, this.getUndefinedReason());
        }
        if (bag.isUndefined()) {
            return bag;
        }
        ArrayList list = new ArrayList(this.collection.size() + bag.collection.size());
        list.addAll(this.collection);
        list.addAll(bag.collection);
        return new OclBag(list);
    }

    public OclUnsortedCollection intersection(OclBag bag) {
        if (this.isUndefined()) {
            return this;
        }
        if (bag.isUndefined()) {
            return new OclSet(0, bag.getUndefinedReason());
        }
        Set set = this.intersection(bag.collection);
        return new OclSet(set);
    }

    public OclSet intersection(OclSet set) {
        if (this.isUndefined()) {
            return this;
        }
        if (set.isUndefined()) {
            return set;
        }
        Set ret = this.intersection(set.collection);
        return new OclSet(ret);
    }

    protected Set intersection(Collection col) {
        Iterator iter = this.collection.iterator();
        HashSet<OclRoot> set = new HashSet<OclRoot>(this.collection.size() * 2);
        while (iter.hasNext()) {
            OclRoot elem = (OclRoot)iter.next();
            if (!col.contains(elem)) continue;
            set.add(elem);
        }
        return set;
    }

    public OclCollection including(OclRoot obj) {
        if (this.isUndefined()) {
            return this;
        }
        if (obj.isUndefined()) {
            return new OclSet(0, obj.getUndefinedReason());
        }
        if (this.STRICT_VALUE_TYPES) {
            HashSet<OclRoot> hs = new HashSet<OclRoot>(this.collection);
            hs.add(obj);
            return new OclSet(hs);
        }
        this.collection.add(obj);
        return this;
    }

    public OclSubtractable subtract(OclSubtractable s) {
        if (this.isUndefined()) {
            return this;
        }
        if (s.isUndefined()) {
            return s;
        }
        try {
            OclSet set = (OclSet)s;
            if (this.STRICT_VALUE_TYPES) {
                HashSet ret = new HashSet(this.collection);
                Iterator iter = set.collection.iterator();
                while (iter.hasNext()) {
                    ret.remove(iter.next());
                }
                return new OclSet(ret);
            }
            Iterator iter = set.collection.iterator();
            while (iter.hasNext()) {
                this.collection.remove(iter.next());
            }
            return this;
        }
        catch (ClassCastException ex) {
            return new OclSet(0, "OclSet subtract called with non-OclSet argument");
        }
    }

    public OclSet symmetricDifference(OclSet set) {
        if (this.isUndefined()) {
            return this;
        }
        if (set.isUndefined()) {
            return set;
        }
        boolean bCreateCopy = this.STRICT_VALUE_TYPES || !(this.collection instanceof HashSet);
        HashSet other = new HashSet(set.collection);
        other.removeAll(this.collection);
        HashSet ret = bCreateCopy ? new HashSet(this.collection) : (HashSet)this.collection;
        ret.removeAll(set.collection);
        ret.addAll(other);
        if (bCreateCopy) {
            return new OclSet(ret);
        }
        return this;
    }

    public OclCollection excluding(OclRoot obj) {
        if (this.isUndefined()) {
            return this;
        }
        if (obj.isUndefined()) {
            return new OclSet(0, obj.getUndefinedReason());
        }
        boolean bCreateCopy = this.STRICT_VALUE_TYPES || !(this.collection instanceof HashSet);
        HashSet ret = bCreateCopy ? new HashSet(this.collection) : (HashSet)this.collection;
        ret.remove(obj);
        if (bCreateCopy) {
            return new OclSet(ret);
        }
        return this;
    }

    public String toString() {
        return "OclSet" + super.toString();
    }
}

