/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignAction
extends UndoableAction {
    private static final long serialVersionUID = 4982051206522858526L;
    public static final int ALIGN_TOPS = 0;
    public static final int ALIGN_BOTTOMS = 1;
    public static final int ALIGN_LEFTS = 2;
    public static final int ALIGN_RIGHTS = 3;
    public static final int ALIGN_CENTERS = 4;
    public static final int ALIGN_H_CENTERS = 5;
    public static final int ALIGN_V_CENTERS = 6;
    public static final int ALIGN_TO_GRID = 7;
    private List<Fig> figs;
    private int direction;
    private Map<Fig, Rectangle> boundsByFig;

    public AlignAction(int dir) {
        super(Localizer.localize("GefBase", "Align" + AlignAction.wordFor(dir)));
        this.direction = dir;
    }

    public AlignAction(int dir, List<Fig> figs) {
        super(Localizer.localize("GefBase", "Align" + AlignAction.wordFor(dir)));
        this.direction = dir;
        this.figs = figs;
    }

    private static String wordFor(int d) {
        switch (d) {
            case 0: {
                return "Tops";
            }
            case 1: {
                return "Bottoms";
            }
            case 2: {
                return "Lefts";
            }
            case 3: {
                return "Rights";
            }
            case 4: {
                return "Centers";
            }
            case 5: {
                return "HorizontalCenters";
            }
            case 6: {
                return "VerticalCenters";
            }
            case 7: {
                return "ToGrid";
            }
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        super.actionPerformed(e);
        ArrayList<Fig> targets = new ArrayList<Fig>();
        Editor ce = Globals.curEditor();
        if (this.figs == null) {
            SelectionManager sm = ce.getSelectionManager();
            if (sm.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            targets.addAll(sm.getSelectedFigs());
        } else {
            targets.addAll(this.figs);
        }
        int size = targets.size();
        if (size == 0) {
            return;
        }
        Rectangle bbox = ((Fig)targets.get(0)).getBounds();
        for (i = 1; i < size; ++i) {
            bbox.add(((Fig)targets.get(i)).getBounds());
        }
        this.boundsByFig = new HashMap<Fig, Rectangle>(size);
        for (i = 0; i < size; ++i) {
            Fig f = (Fig)targets.get(i);
            this.boundsByFig.put(f, f.getBounds());
            f.align(bbox, this.direction, ce);
            f.endTrans();
        }
    }
}

