/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.OCLExpander;
import org.tigris.gef.ocl.TemplateReader;
import org.tigris.gef.util.Localizer;

public class SavePGMLAction
extends AbstractAction
implements FilenameFilter {
    private static final long serialVersionUID = 8033817528836858940L;
    private static OCLExpander _expander = null;

    public SavePGMLAction() {
    }

    public SavePGMLAction(String name) {
        this(name, false);
    }

    public SavePGMLAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public SavePGMLAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SavePGMLAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            _expander = new OCLExpander(TemplateReader.getInstance().read("/org/tigris/gef/xml/dtd/PGML.tee"));
            Editor ce = Globals.curEditor();
            Diagram d = new Diagram("junk", ce.getGraphModel(), (LayerPerspective)ce.getLayerManager().getActiveLayer());
            FileDialog fd = new FileDialog(ce.findFrame(), "Save Diagram in PGML format", 1);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Writing " + path + filename + "...");
                FileWriter fw = new FileWriter(path + filename);
                System.out.println("Action save in PGML...");
                _expander.expand(fw, (Object)d);
                System.out.println("save done");
                Globals.showStatus("Wrote " + path + filename);
                fw.close();
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
            ignore.printStackTrace();
        }
        catch (ExpansionException e) {
            System.out.println("got an Exception");
            e.printStackTrace();
        }
    }

    public boolean accept(File dir, String name) {
        return true;
    }
}

