/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public class SelectionLowerRight
extends Selection {
    private static final long serialVersionUID = 434028821570397508L;

    public SelectionLowerRight(Fig f) {
        super(f);
    }

    public void hitHandle(Rectangle r, Handle h) {
        int ch;
        int cx = this.getContent().getX();
        int cy = this.getContent().getY();
        int cw = this.getContent().getWidth();
        Rectangle testRect = new Rectangle(cx + cw, cy + (ch = this.getContent().getHeight()), 6, 6);
        if (r.intersects(testRect)) {
            h.index = 7;
            h.instructions = "Resize object";
        } else {
            h.index = -1;
        }
    }

    public void paint(Graphics g) {
        int cx = this.getContent().getX();
        int cy = this.getContent().getY();
        int cw = this.getContent().getWidth();
        int ch = this.getContent().getHeight();
        g.setColor(Globals.getPrefs().handleColorFor(this.getContent()));
        g.drawRect(cx - 3, cy - 3, cw + 6 - 1, ch + 6 - 1);
        g.fillRect(cx + cw, cy + ch, 6, 6);
    }

    public void dragHandle(int mX, int mY, int anX, int anY, Handle hand) {
        int x = this.getContent().getX();
        int y = this.getContent().getY();
        int w = this.getContent().getWidth();
        int h = this.getContent().getHeight();
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        Dimension minSize = this.getContent().getMinimumSize();
        int minWidth = minSize.width;
        int minHeight = minSize.height;
        switch (hand.index) {
            case -1: {
                this.getContent().translate(anX - mX, anY - mY);
                return;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                newW = mX - x;
                newW = newW < minWidth ? minWidth : newW;
                newH = mY - y;
                newH = newH < minHeight ? minHeight : newH;
                break;
            }
            default: {
                System.out.println("invalid handle number");
            }
        }
        this.getContent().setBounds(newX, newY, newW, newH);
    }
}

