/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.tigris.swidgets.DimensionUtility;
import org.tigris.swidgets.Horizontal;
import org.tigris.swidgets.Orientation;
import org.tigris.swidgets.Vertical;

public abstract class LineLayout
implements LayoutManager2 {
    public static final Orientation HORIZONTAL = Horizontal.getInstance();
    public static final Orientation VERTICAL = Vertical.getInstance();
    protected Orientation _orientation;
    protected int _gap = 0;

    public LineLayout(Orientation orientation) {
        this._orientation = orientation;
    }

    public LineLayout(Orientation orientation, int n) {
        this._orientation = orientation;
        this._gap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            dimension = this._orientation.addLength(dimension, this._orientation.getLength(component.getPreferredSize()) + n2);
            n2 = this._gap;
            if (this._orientation.getBreadth(component.getPreferredSize()) <= this._orientation.getBreadth(dimension)) continue;
            dimension = this._orientation.setBreadth(dimension, component.getPreferredSize());
        }
        dimension = DimensionUtility.add(dimension, container.getInsets());
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            dimension = this._orientation.addLength(dimension, this._orientation.getLength(component.getMinimumSize()) + n2);
            n2 = this._gap;
            if (this._orientation.getBreadth(component.getMinimumSize()) <= this._orientation.getBreadth(dimension)) continue;
            dimension = this._orientation.setBreadth(dimension, component.getMinimumSize());
        }
        dimension = DimensionUtility.add(dimension, container.getInsets());
        return dimension;
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension2 = component.getMaximumSize();
            if (!component.isVisible() || dimension2 == null) continue;
            dimension = this._orientation.addLength(dimension, this._orientation.getLength(dimension2) + n2);
            n2 = this._gap;
            if (this._orientation.getBreadth(dimension2) >= this._orientation.getBreadth(dimension)) continue;
            dimension = this._orientation.setBreadth(dimension, dimension2);
        }
        dimension = DimensionUtility.add(dimension, container.getInsets());
        return dimension;
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }
}

