/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.tigris.swidgets.Property;

public class PropertyTable
extends JTable {
    private static final String DEFAULT_NAME_TITLE = "Property";
    private static final String DEFAULT_VALUE_TITLE = "Value";
    private static final String DETERMINE_HEIGHT_TEXT = "ABC";
    private Property[] properties;
    private String nameColumnTitle;
    private String valueColumnTitle;
    static /* synthetic */ Class class$java$lang$Object;

    public PropertyTable(Property[] propertyArray) {
        this(propertyArray, DEFAULT_NAME_TITLE, DEFAULT_VALUE_TITLE);
    }

    public PropertyTable(Property[] propertyArray, String string, String string2) {
        this.properties = propertyArray;
        this.nameColumnTitle = string;
        this.valueColumnTitle = string2;
        this.setModel(new PropertyTableModel());
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{DETERMINE_HEIGHT_TEXT});
        this.setRowHeight(jComboBox.getPreferredSize().height);
        int n = Math.min(this.getPreferredSize().width, this.getPreferredScrollableViewportSize().width);
        int n2 = Math.min(this.getPreferredSize().height, this.getPreferredScrollableViewportSize().height);
        this.setPreferredScrollableViewportSize(new Dimension(n, n2));
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = null;
        if (n2 == 1) {
            Object[] objectArray = this.properties[n].getAvailableValues();
            if (objectArray != null) {
                JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.setEditable(false);
                tableCellEditor = new DefaultCellEditor(jComboBox);
            } else {
                tableCellEditor = this.getDefaultEditor(this.properties[n].getValueType());
            }
        }
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = n2 == 1 ? this.getDefaultRenderer(this.properties[n].getValueType()) : this.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PropertyTable.class$("java.lang.Object")) : class$java$lang$Object);
        return tableCellRenderer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PropertyTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return PropertyTable.this.properties.length;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return PropertyTable.this.nameColumnTitle;
            }
            if (n == 1) {
                return PropertyTable.this.valueColumnTitle;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return PropertyTable.this.properties[n].getName();
            }
            if (n2 == 1) {
                return PropertyTable.this.properties[n].getCurrentValue();
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                PropertyTable.this.properties[n].setCurrentValue(object);
            }
        }
    }
}

