/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import java.io.IOException;
import java.io.Reader;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.LexerSource;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.Token;

public class CppReader
extends Reader {
    private Preprocessor cpp;
    private String token;
    private int idx;

    public CppReader(final Reader r) {
        this.cpp = new Preprocessor(new LexerSource(r, true){

            public String getName() {
                return "<CppReader Input@" + System.identityHashCode(r) + ">";
            }
        });
        this.token = "";
        this.idx = 0;
    }

    public CppReader(Preprocessor p) {
        this.cpp = p;
        this.token = "";
        this.idx = 0;
    }

    public Preprocessor getPreprocessor() {
        return this.cpp;
    }

    public void addMacro(String name) throws LexerException {
        this.cpp.addMacro(name);
    }

    public void addMacro(String name, String value) throws LexerException {
        this.cpp.addMacro(name, value);
    }

    private boolean refill() throws IOException {
        try {
            assert (this.cpp != null) : "cpp is null : was it closed?";
            if (this.token == null) {
                return false;
            }
            while (this.idx >= this.token.length()) {
                Token tok = this.cpp.token();
                switch (tok.getType()) {
                    case 264: {
                        this.token = null;
                        return false;
                    }
                }
                this.token = tok.getText();
                this.idx = 0;
            }
            return true;
        }
        catch (LexerException e) {
            IOException ie = new IOException(String.valueOf(e));
            ie.initCause(e);
            throw ie;
        }
    }

    public int read() throws IOException {
        if (!this.refill()) {
            return -1;
        }
        return this.token.charAt(this.idx++);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.token == null) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public void close() throws IOException {
        this.cpp = null;
        this.token = null;
    }
}

