/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

import org.anarres.cpp.LexerException;
import org.anarres.cpp.Source;

public class PreprocessorListener {
    private int errors;
    private int warnings;

    public PreprocessorListener() {
        this.clear();
    }

    public void clear() {
        this.errors = 0;
        this.warnings = 0;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getWarnings() {
        return this.warnings;
    }

    protected void print(String msg) {
        System.err.println(msg);
    }

    public void handleWarning(Source source, int line, int column, String msg) throws LexerException {
        ++this.warnings;
        this.print(source.getName() + ":" + line + ":" + column + ": warning: " + msg);
    }

    public void handleError(Source source, int line, int column, String msg) throws LexerException {
        ++this.errors;
        this.print(source.getName() + ":" + line + ":" + column + ": error: " + msg);
    }

    public void handleSourceChange(Source source, String event) {
    }
}

